/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.impl.DefaultEngineFactory;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.HttpGatewayServiceClient;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import io.fabric8.gateway.apiman.ApiManEngine;
import io.fabric8.gateway.apiman.Fabric8ConnectorFactory;
import io.fabric8.gateway.apiman.FileBackedRegistry;
import java.util.Map;
import org.vertx.java.core.Vertx;

public class Engine {
    private FileBackedRegistry registry;

    public ApiManEngine create(final Vertx vertx, final HttpGateway httpGateway, final String port) {
        DefaultEngineFactory factory = new DefaultEngineFactory(){

            protected IConnectorFactory createConnectorFactory() {
                HttpGatewayServiceClient httpGatewayServiceClient = new HttpGatewayServiceClient(vertx, httpGateway);
                return new Fabric8ConnectorFactory(vertx, httpGatewayServiceClient);
            }

            protected IRegistry createRegistry() {
                try {
                    Engine.this.registry = new FileBackedRegistry();
                    Engine.this.registry.load(port);
                    return Engine.this.registry;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
        final IEngine engine = factory.createEngine();
        ApiManEngine apimanEngine = new ApiManEngine(){

            public void unregisterApplication(String organizationId, String applicationId, String version) throws RegistrationException {
                engine.unregisterApplication(organizationId, applicationId, version);
            }

            public void retireService(String organizationId, String serviceId, String version) throws PublishingException {
                engine.retireService(organizationId, serviceId, version);
            }

            public void registerApplication(Application application) throws RegistrationException {
                engine.registerApplication(application);
            }

            public void publishService(Service service) throws PublishingException {
                engine.publishService(service);
            }

            public String getVersion() {
                return engine.getVersion();
            }

            public IServiceRequestExecutor executor(ServiceRequest request, IAsyncResultHandler<IEngineResult> resultHandler) {
                return engine.executor(request, resultHandler);
            }

            @Override
            public String serviceMapping(String orgId, String serviceId, String version) throws NotAuthorizedException {
                Service service = Engine.this.registry.serviceLookup(orgId, serviceId, version);
                String serviceUrl = service.getEndpoint();
                Map mappedServices = httpGateway.getMappedServices();
                for (String key : mappedServices.keySet()) {
                    IMappedServices services = (IMappedServices)mappedServices.get(key);
                    String servicePath = services.getProxyMappingDetails().getProxyServiceUrl();
                    if (!servicePath.equals(serviceUrl)) continue;
                    String gatewayUrl = httpGateway.getGatewayUrl() + key;
                    return gatewayUrl;
                }
                throw new NotAuthorizedException("Service not found");
            }
        };
        return apimanEngine;
    }
}

