/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.IServiceConnector;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.ConnectorException;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.fabric8.gateway.api.handlers.http.HttpGatewayServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpServerRequest;

public class Fabric8ConnectorFactory
implements IConnectorFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(Fabric8ConnectorFactory.class);
    private HttpGatewayServiceClient httpGatewayClient;

    public Fabric8ConnectorFactory(Vertx vertx, HttpGatewayServiceClient httpGatewayClient) {
        this.httpGatewayClient = httpGatewayClient;
    }

    public IServiceConnector createConnector(ServiceRequest request, Service service) {
        IServiceConnector connector = new IServiceConnector(){

            public IServiceConnection connect(ServiceRequest serviceRequest, IAsyncResultHandler<IServiceConnectionResponse> handler) throws ConnectorException {
                final HttpServerRequest httpRequest = (HttpServerRequest)serviceRequest.getRawRequest();
                httpRequest.headers().set(serviceRequest.getHeaders());
                final HttpClientRequest vxServiceClientRequest = Fabric8ConnectorFactory.this.httpGatewayClient.execute(httpRequest, handler);
                return new IServiceConnection(){
                    private boolean streamFinished = false;

                    public void abort() {
                        LOG.warn("Abort called for request " + httpRequest.path());
                        this.end();
                    }

                    public void write(IApimanBuffer chunk) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Writing chuck for " + httpRequest.path() + ": " + chunk);
                        }
                        if (this.streamFinished) {
                            throw new IllegalStateException("Attempted write to connector after #end() was called.");
                        }
                        if (!(chunk.getNativeBuffer() instanceof Buffer)) {
                            throw new IllegalArgumentException("Chunk not of expected Vert.x Buffer type.");
                        }
                        vxServiceClientRequest.write((Buffer)chunk.getNativeBuffer());
                    }

                    public void end() {
                        vxServiceClientRequest.end();
                        this.streamFinished = true;
                    }

                    public boolean isFinished() {
                        return this.streamFinished;
                    }
                };
            }
        };
        return connector;
    }
}

