/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.i18n.Messages;
import io.fabric8.gateway.apiman.ApiManRegistryInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedRegistry
implements IRegistry {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileBackedRegistry.class);
    private static File registryFile = null;
    private Map<String, Service> services = new HashMap<String, Service>();
    private Map<String, Application> applications = new HashMap<String, Application>();
    private Map<String, ServiceContract> contracts = new HashMap<String, ServiceContract>();

    public static File getRegistryFile() throws IOException {
        if (registryFile == null) {
            File apiManDataDir;
            String appDir = null;
            if (System.getenv("APP_BASE") != null) {
                appDir = System.getenv("APP_BASE");
            } else if (System.getProperty("APP_BASE") != null) {
                appDir = System.getProperty("APP_BASE");
            }
            File mavenDir = new File("/maven");
            if (mavenDir.exists()) {
                appDir = mavenDir.getAbsolutePath();
            }
            if (appDir == null) {
                appDir = System.getProperty("user.home");
                LOG.info("Cannot find 'APP_BASE' system param or '/maven' dir, defaulting to user's home dir " + appDir);
            }
            if (!(apiManDataDir = new File(appDir + "/data/apiman")).exists()) {
                apiManDataDir.mkdirs();
            }
            if (!(registryFile = new File(apiManDataDir.getAbsolutePath() + "/registry.json")).exists()) {
                LOG.info("Creating new APIMan JSON Datafile " + registryFile.getAbsolutePath());
                registryFile.createNewFile();
            }
            LOG.info("ApiMan is using data file " + registryFile.getAbsolutePath());
        }
        return registryFile;
    }

    public void load(String port) throws IOException {
        String json = null;
        if (FileBackedRegistry.getRegistryFile().exists()) {
            json = IOUtils.toString((URI)FileBackedRegistry.getRegistryFile().toURI(), (String)"UTF-8");
        }
        if (json == null || json.length() == 0) {
            LOG.info(registryFile.getAbsolutePath() + " has no content which can happen on first use." + " Running ApiMan bootstrap process");
            FileBackedRegistry.getRegistryFile().createNewFile();
            InputStream is = this.getClass().getResourceAsStream("RegistryInfo.json");
            json = IOUtils.toString((InputStream)is);
            if (port != null) {
                json = json.replaceAll("\\$\\{port\\}", port);
            }
        }
        ApiManRegistryInfo registryInfo = ApiManRegistryInfo.fromJSON(json);
        for (Service service : registryInfo.getServices()) {
            this.services.put(this.getServiceKey(service), service);
        }
        for (Application application : registryInfo.getApplications()) {
            this.applications.put(this.getApplicationKey(application), application);
            for (Contract contract : application.getContracts()) {
                String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
                ServiceContract sc = new ServiceContract(contract.getApiKey(), this.services.get(svcKey), application, contract.getPolicies());
                this.contracts.put(contract.getApiKey(), sc);
            }
        }
    }

    public void save() {
        try {
            ApiManRegistryInfo registryInfo = new ApiManRegistryInfo(this.services.values(), this.applications.values());
            String json = registryInfo.toJSON();
            FileUtils.writeStringToFile((File)FileBackedRegistry.getRegistryFile(), (String)json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void publishService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (this.services.containsKey(serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceAlreadyPublished", new Object[0]));
        }
        this.services.put(serviceKey, service);
        this.save();
    }

    public synchronized void retireService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (!this.services.containsKey(serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceNotFound", new Object[0]));
        }
        this.services.remove(serviceKey);
    }

    public synchronized void registerApplication(Application application) throws RegistrationException {
        for (Contract contract : application.getContracts()) {
            if (this.contracts.containsKey(contract.getApiKey())) {
                throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.ContractAlreadyPublished", new Object[]{contract.getApiKey()}));
            }
            String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            if (this.services.containsKey(svcKey)) continue;
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.ServiceNotFoundInOrg", new Object[]{contract.getServiceId(), contract.getServiceOrgId()}));
        }
        String applicationKey = this.getApplicationKey(application);
        if (this.applications.containsKey(applicationKey)) {
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppAlreadyRegistered", new Object[0]));
        }
        this.applications.put(applicationKey, application);
        for (Contract contract : application.getContracts()) {
            String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            ServiceContract sc = new ServiceContract(contract.getApiKey(), this.services.get(svcKey), application, contract.getPolicies());
            this.contracts.put(contract.getApiKey(), sc);
        }
        this.save();
    }

    public synchronized void unregisterApplication(Application application) throws RegistrationException {
        String applicationKey = this.getApplicationKey(application);
        if (this.applications.containsKey(applicationKey)) {
            Application removed = this.applications.remove(applicationKey);
            for (Contract contract : removed.getContracts()) {
                if (!this.contracts.containsKey(contract.getApiKey())) continue;
                this.contracts.remove(contract.getApiKey());
            }
        } else {
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppNotFound", new Object[0]));
        }
        this.save();
    }

    public ServiceContract getContract(ServiceRequest request) throws InvalidContractException {
        ServiceContract contract = this.contracts.get(request.getApiKey());
        if (contract == null) {
            throw new InvalidContractException(Messages.i18n.format("InMemoryRegistry.NoContractForAPIKey", new Object[]{request.getApiKey()}));
        }
        return contract;
    }

    private String getServiceKey(Service service) {
        return this.getServiceKey(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceKey(String orgId, String serviceId, String version) {
        return orgId + "|" + serviceId + "|" + version;
    }

    private String getApplicationKey(Application app) {
        return app.getOrganizationId() + "|" + app.getApplicationId() + "|" + app.getVersion();
    }

    public Service serviceLookup(String orgId, String serviceId, String version) {
        String serviceKey = this.getServiceKey(orgId, serviceId, version);
        if (this.services.containsKey(serviceKey)) {
            return this.services.get(serviceKey);
        }
        return null;
    }
}

