/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.fabric8.gateway.apiman.ApiManEngine;
import io.fabric8.gateway.apiman.rest.ApplicationResource;
import io.fabric8.gateway.apiman.rest.ServiceResource;
import io.fabric8.gateway.apiman.rest.SystemResource;
import io.fabric8.gateway.apiman.rest.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class RestDispatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(RestDispatcher.class);
    private ObjectMapper mapper;

    public ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        return this.mapper;
    }

    public void dispatch(final HttpServerRequest request, final ApiManEngine engine) {
        String contentType;
        if (request.method().equals("PUT") && ((contentType = request.headers().get("Content-Type")) == null || !contentType.startsWith("application/json"))) {
            request.response().setStatusCode(403);
            request.response().end("Expecting Content-Type of 'application/json'");
            request.response().close();
            return;
        }
        request.bodyHandler((Handler)new Handler<Buffer>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handle(Buffer event) {
                try {
                    String body = event.getString(0, event.length());
                    String uri = request.uri().substring(1);
                    if (uri.contains("?")) {
                        uri = uri.substring(0, uri.indexOf("?"));
                    }
                    String[] pathSegment = uri.split("/");
                    if (uri.startsWith("rest/apimanager/applications")) {
                        ApplicationResource applicationResource = new ApplicationResource(engine);
                        if (request.method().equals("PUT")) {
                            Application application = (Application)RestDispatcher.this.getObjectMapper().readValue(body, Application.class);
                            applicationResource.register(application);
                        } else {
                            if (!request.method().equals("DELETE")) throw new UserException("Method not Supported");
                            if (pathSegment.length < 6) {
                                throw new UserException("Query Parse Exception , expecting /rest/apimanager/applications/{organizationId}/{applicationId}/{version}");
                            }
                            String organizationId = pathSegment[3];
                            String applicationId = pathSegment[4];
                            String version = pathSegment[5];
                            applicationResource.unregister(organizationId, applicationId, version);
                        }
                    } else if (uri.startsWith("rest/apimanager/services")) {
                        ServiceResource serviceResource = new ServiceResource(engine);
                        if (request.method().equals("PUT")) {
                            Service service = (Service)RestDispatcher.this.getObjectMapper().readValue(body, Service.class);
                            serviceResource.publish(service);
                        } else if (request.method().equals("DELETE")) {
                            if (pathSegment.length < 6) {
                                throw new UserException("Query Parse Exception , expecting /rest/apimanager/applications/{organizationId}/{serviceId}/{version}");
                            }
                            String organizationId = pathSegment[3];
                            String serviceId = pathSegment[4];
                            String version = pathSegment[5];
                            serviceResource.retire(organizationId, serviceId, version);
                            request.response().setStatusCode(200);
                        } else {
                            if (!request.method().equals("GET")) throw new UserException("Method not Supported");
                            if (pathSegment.length < 7) {
                                throw new UserException("Query Parse Exception , expecting /rest/apimanager/applications/{organizationId}/{serviceId}/{version}/endpoint");
                            }
                            String organizationId = pathSegment[3];
                            String serviceId = pathSegment[4];
                            String version = pathSegment[5];
                            String json = RestDispatcher.this.getObjectMapper().writeValueAsString((Object)serviceResource.getServiceEndpoint(organizationId, serviceId, version));
                            request.response().headers().set("ContentType", "application/json");
                            request.response().headers().set("Content-Length", String.valueOf(json.length()));
                            request.response().write(json);
                        }
                    } else {
                        if (!uri.startsWith("rest/apimanager/system/status")) throw new UserException("No Such Service");
                        SystemResource systemResource = new SystemResource(engine);
                        String json = RestDispatcher.this.getObjectMapper().writeValueAsString((Object)systemResource.getStatus());
                        request.response().headers().set("ContentType", "application/json");
                        request.response().headers().set("Content-Length", String.valueOf(json.length()));
                        request.response().write(json);
                    }
                    request.response().setStatusCode(200);
                    request.response().end();
                    request.response().close();
                    return;
                }
                catch (UserException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    request.response().setStatusCode(404);
                    request.response().setStatusMessage(e.getMessage());
                    request.response().end();
                    request.response().close();
                    return;
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage(), e);
                    request.response().setStatusCode(500);
                    request.response().setStatusMessage(e.getMessage());
                    request.response().end();
                    request.response().close();
                }
            }
        });
    }
}

