/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman.rest;

import io.apiman.gateway.api.rest.contract.IServiceResource;
import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceEndpoint;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.fabric8.gateway.apiman.ApiManEngine;

public class ServiceResource
implements IServiceResource {
    private ApiManEngine engine;

    public ServiceResource(ApiManEngine engine) {
        this.engine = engine;
    }

    public void publish(Service service) throws PublishingException, NotAuthorizedException {
        this.engine.publishService(service);
    }

    public void retire(String organizationId, String serviceId, String version) throws PublishingException, NotAuthorizedException {
        this.engine.retireService(organizationId, serviceId, version);
    }

    public ServiceEndpoint getServiceEndpoint(String orgId, String serviceId, String version) throws NotAuthorizedException {
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        serviceEndpoint.setEndpoint(this.engine.serviceMapping(orgId, serviceId, version));
        return serviceEndpoint;
    }
}

