/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffEditFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class DiffLineCountFilter
extends CommitDiffEditFilter {
    private long added;
    private long edited;
    private long deleted;

    public DiffLineCountFilter() {
    }

    public DiffLineCountFilter(boolean detectRenames) {
        super(detectRenames);
    }

    public long getAdded() {
        return this.added;
    }

    public long getEdited() {
        return this.edited;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getTotal() {
        return this.added + this.edited + this.deleted;
    }

    @Override
    protected boolean include(RevCommit commit, DiffEntry diff, Edit hunk) {
        switch (hunk.getType()) {
            case DELETE: {
                this.deleted += (long)hunk.getLengthA();
                break;
            }
            case INSERT: {
                this.added += (long)hunk.getLengthB();
                break;
            }
            case REPLACE: {
                this.edited += (long)hunk.getLengthB();
            }
        }
        return true;
    }

    @Override
    public CommitFilter reset() {
        this.added = 0L;
        this.edited = 0L;
        this.deleted = 0L;
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new DiffLineCountFilter(this.detectRenames);
    }
}

