/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildListFluent;
import io.fabric8.openshift.api.model.BuildListFluentImpl;
import javax.validation.Validator;

public class BuildListBuilder
extends BuildListFluentImpl<BuildListBuilder>
implements VisitableBuilder<BuildList, BuildListBuilder> {
    BuildListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildListBuilder() {
        this(true);
    }

    public BuildListBuilder(Boolean validationEnabled) {
        this(new BuildList(), validationEnabled);
    }

    public BuildListBuilder(BuildListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildListBuilder(BuildListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildList(), validationEnabled);
    }

    public BuildListBuilder(BuildListFluent<?> fluent, BuildList instance) {
        this(fluent, instance, true);
    }

    public BuildListBuilder(BuildListFluent<?> fluent, BuildList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildListBuilder(BuildList instance) {
        this(instance, (Boolean)true);
    }

    public BuildListBuilder(BuildList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BuildListBuilder(Validator validator) {
        this(new BuildList(), (Boolean)true);
    }

    public BuildListBuilder(BuildListFluent<?> fluent, BuildList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildListBuilder(BuildList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildList build() {
        BuildList buildable = new BuildList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildListBuilder that = (BuildListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

