/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceFluent;
import io.fabric8.openshift.api.model.RouteTargetReferenceFluentImpl;
import javax.validation.Validator;

public class RouteTargetReferenceBuilder
extends RouteTargetReferenceFluentImpl<RouteTargetReferenceBuilder>
implements VisitableBuilder<RouteTargetReference, RouteTargetReferenceBuilder> {
    RouteTargetReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteTargetReferenceBuilder() {
        this(true);
    }

    public RouteTargetReferenceBuilder(Boolean validationEnabled) {
        this(new RouteTargetReference(), validationEnabled);
    }

    public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteTargetReference(), validationEnabled);
    }

    public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent, RouteTargetReference instance) {
        this(fluent, instance, true);
    }

    public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent, RouteTargetReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withWeight(instance.getWeight());
        this.validationEnabled = validationEnabled;
    }

    public RouteTargetReferenceBuilder(RouteTargetReference instance) {
        this(instance, (Boolean)true);
    }

    public RouteTargetReferenceBuilder(RouteTargetReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withWeight(instance.getWeight());
        this.validationEnabled = validationEnabled;
    }

    public RouteTargetReferenceBuilder(Validator validator) {
        this(new RouteTargetReference(), (Boolean)true);
    }

    public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent, RouteTargetReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withWeight(instance.getWeight());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RouteTargetReferenceBuilder(RouteTargetReference instance, Validator validator) {
        this.fluent = this;
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withWeight(instance.getWeight());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RouteTargetReference build() {
        RouteTargetReference buildable = new RouteTargetReference(this.fluent.getKind(), this.fluent.getName(), this.fluent.getWeight());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteTargetReferenceBuilder that = (RouteTargetReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

