package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OSDiskBuilder extends OSDiskFluent<OSDiskBuilder> implements VisitableBuilder<OSDisk,OSDiskBuilder>{
  public OSDiskBuilder() {
    this(new OSDisk());
  }
  
  public OSDiskBuilder(OSDiskFluent<?> fluent) {
    this(fluent, new OSDisk());
  }
  
  public OSDiskBuilder(OSDiskFluent<?> fluent,OSDisk instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OSDiskBuilder(OSDisk instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OSDiskFluent<?> fluent;
  
  public OSDisk build() {
    OSDisk buildable = new OSDisk(fluent.getDiskSizeGB(),fluent.getDiskType(),fluent.buildEncryptionKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}