/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.runner;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Scheduler;
import akka.pattern.AskSupport;
import akka.util.Timeout;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.akka.AkkaDefaults;
import io.gatling.core.akka.AkkaDefaults$class;
import io.gatling.core.akka.GatlingActorSystem$;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.Run;
import io.gatling.core.runner.Selection;
import io.gatling.core.scenario.Simulation;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u0017\t1!+\u001e8oKJT!a\u0001\u0003\u0002\rI,hN\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001\u0019IA\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!\u0011m[6b\u0013\t9BC\u0001\u0007BW.\fG)\u001a4bk2$8\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013!C:fY\u0016\u001cG/[8o!\t)c%D\u0001\u0003\u0013\t9#AA\u0005TK2,7\r^5p]\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005\u0015\u0002\u0001\"B\u0012)\u0001\u0004!\u0003\"\u0002\u0018\u0001\t\u0003y\u0013a\u0001:v]V\t\u0001\u0007\u0005\u00022i9\u0011QBM\u0005\u0003g9\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111G\u0004")
public class Runner
implements AkkaDefaults,
StrictLogging {
    private final Selection selection;
    private final Logger logger;
    private final FiniteDuration simulationTimeOut;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public FiniteDuration simulationTimeOut() {
        return this.simulationTimeOut;
    }

    @Override
    public void io$gatling$core$akka$AkkaDefaults$_setter_$simulationTimeOut_$eq(FiniteDuration x$1) {
        this.simulationTimeOut = x$1;
    }

    @Override
    public ActorSystem system() {
        return AkkaDefaults$class.system(this);
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return AkkaDefaults$class.dispatcher(this);
    }

    @Override
    public Scheduler scheduler() {
        return AkkaDefaults$class.scheduler(this);
    }

    @Override
    public String actorName(String base) {
        return AkkaDefaults$class.actorName(this, base);
    }

    public ActorRef ask(ActorRef actorRef) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef);
    }

    public Future<Object> ask(ActorRef actorRef, Object message, Timeout timeout) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef, (Object)message, (Timeout)timeout);
    }

    public ActorSelection ask(ActorSelection actorSelection) {
        return AskSupport.class.ask((AskSupport)this, (ActorSelection)actorSelection);
    }

    public Future<Object> ask(ActorSelection actorSelection, Object message, Timeout timeout) {
        return AskSupport.class.ask((AskSupport)this, (ActorSelection)actorSelection, (Object)message, (Timeout)timeout);
    }

    /*
     * WARNING - void declaration
     */
    public String run() {
        try {
            Success success;
            Object runId;
            Object object;
            Class<Simulation> simulationClass = this.selection.simulationClass();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " started..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationClass.getName()})));
            GatlingActorSystem$.MODULE$.start();
            Simulation simulation = simulationClass.newInstance();
            System.gc();
            System.gc();
            System.gc();
            Controller$.MODULE$.start();
            simulation._beforeSteps().foreach((Function1)new Serializable(this){

                public final void apply(Function0<BoxedUnit> x$1) {
                    x$1.apply$mcV$sp();
                }
            });
            Timeout timeOut = new Timeout(this.simulationTimeOut());
            Future<Object> runResult = Controller$.MODULE$.$qmark(new Run(simulation, this.selection.simulationId(), this.selection.description(), simulation.timings()), timeOut);
            try {
                Object res;
                object = res = Await$.MODULE$.result(runResult, (Duration)this.simulationTimeOut());
            }
            catch (TimeoutException timeoutException) {
                void var4_3;
                throw new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reach simulation timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_3})));
            }
            if (object instanceof Success && (runId = (success = (Success)object).value()) instanceof String) {
                String string2 = (String)runId;
                Predef$.MODULE$.println((Object)"Simulation finished");
                simulation._afterSteps().foreach((Function1)new Serializable(this){

                    public final void apply(Function0<BoxedUnit> x$2) {
                        x$2.apply$mcV$sp();
                    }
                });
                String string3 = string2;
                return string3;
            }
            if (object instanceof Failure) {
                Failure failure = (Failure)object;
                Throwable t = failure.exception();
                throw t;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller replied an unexpected message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
        }
        finally {
            GatlingActorSystem$.MODULE$.shutdown();
        }
    }

    public Runner(Selection selection) {
        this.selection = selection;
        AskSupport.class.$init$((AskSupport)this);
        AkkaDefaults$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

