/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.util.cache;

import com.github.benmanes.caffeine.cache.LoadingCache;
import io.gatling.core.util.cache.Cache$;
import java.util.concurrent.ConcurrentMap;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]r!B\u0001\u0003\u0011\u0003i\u0011!B\"bG\",'BA\u0002\u0005\u0003\u0015\u0019\u0017m\u00195f\u0015\t)a!\u0001\u0003vi&d'BA\u0004\t\u0003\u0011\u0019wN]3\u000b\u0005%Q\u0011aB4bi2Lgn\u001a\u0006\u0002\u0017\u0005\u0011\u0011n\\\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005\u0015\u0019\u0015m\u00195f'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQ\u0001H\b\u0005\u0002u\t!C\\3x\u0007>t7-\u001e:sK:$8)Y2iKV\u0019aD\u000b\u001b\u0015\u0005}1\u0004\u0003\u0002\u0011'QMj\u0011!\t\u0006\u0003E\r\n!bY8oGV\u0014(/\u001a8u\u0015\t)AEC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\n#!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002*U1\u0001A!B\u0016\u001c\u0005\u0004a#!A&\u0012\u00055\u0002\u0004CA\n/\u0013\tyCCA\u0004O_RD\u0017N\\4\u0011\u0005M\t\u0014B\u0001\u001a\u0015\u0005\r\te.\u001f\t\u0003SQ\"Q!N\u000eC\u00021\u0012\u0011A\u0016\u0005\u0006om\u0001\r\u0001O\u0001\b[\u0006D8+\u001b>f!\t\u0019\u0012(\u0003\u0002;)\t!Aj\u001c8h\u0011\u0015at\u0002\"\u0001>\u0003eqWm^\"p]\u000e,(O]3oi2{\u0017\rZ5oO\u000e\u000b7\r[3\u0016\u0007yju\nF\u0002@!F\u0003B\u0001\u0011&M\u001d6\t\u0011I\u0003\u0002\u0004\u0005*\u00111\tR\u0001\tG\u00064g-Z5oK*\u0011QIR\u0001\tE\u0016tW.\u00198fg*\u0011q\tS\u0001\u0007O&$\b.\u001e2\u000b\u0003%\u000b1aY8n\u0013\tY\u0015I\u0001\u0007M_\u0006$\u0017N\\4DC\u000eDW\r\u0005\u0002*\u001b\u0012)1f\u000fb\u0001YA\u0011\u0011f\u0014\u0003\u0006km\u0012\r\u0001\f\u0005\u0006om\u0002\r\u0001\u000f\u0005\u0006%n\u0002\raU\u0001\u0002MB!1\u0003\u0016'O\u0013\t)FCA\u0005Gk:\u001cG/[8oc!)qk\u0004C\u00011\u0006\tb.Z<J[6,H/\u00192mK\u000e\u000b7\r[3\u0016\u000be\u000by#a\r\u0015\u0007i\u000b)\u0004\u0005\u0004\u000f7\u00065\u0012\u0011\u0007\u0004\u0005!\t\u0001A,F\u0002^Sb\u001c\"a\u0017\n\t\u0011}[&\u0011!Q\u0001\n\u0001\fQ!];fk\u0016\u00042!\u00194i\u001b\u0005\u0011'BA2e\u0003%IW.\\;uC\ndWM\u0003\u0002f)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0014'!B)vKV,\u0007CA\u0015j\t\u0015Y3L1\u0001-\u0011!Y7L!A!\u0002\u0013a\u0017aA7baB!Q\u000e\u001e5x\u001d\tq'\u000f\u0005\u0002p)5\t\u0001O\u0003\u0002r\u0019\u00051AH]8pizJ!a\u001d\u000b\u0002\rA\u0013X\rZ3g\u0013\t)hOA\u0002NCBT!a\u001d\u000b\u0011\u0005%BH!B\u001b\\\u0005\u0004a\u0003\u0002\u0003>\\\u0005\u0003\u0005\u000b\u0011B>\u0002\u00175\f\u0007pQ1qC\u000eLG/\u001f\t\u0003'qL!! \u000b\u0003\u0007%sG\u000fC\u0003\u001a7\u0012\u0005q\u0010\u0006\u0005\u0002\u0002\u0005\r\u0011QAA\u0004!\u0011q1\f[<\t\u000b}s\b\u0019\u00011\t\u000b-t\b\u0019\u00017\t\u000bit\b\u0019A>\t\u000f\u0005-1\f\"\u0001\u0002\u000e\u0005\u0019\u0001/\u001e;\u0015\r\u0005\u0005\u0011qBA\n\u0011\u001d\t\t\"!\u0003A\u0002!\f1a[3z\u0011\u001d\t)\"!\u0003A\u0002]\fQA^1mk\u0016Dq!!\u0007\\\t\u0003\tY\"\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003\u0003\ti\u0002C\u0004\u0002\u0012\u0005]\u0001\u0019\u00015\t\u000f\u0005\u00052\f\"\u0001\u0002$\u0005\u0019q-\u001a;\u0015\t\u0005\u0015\u00121\u0006\t\u0005'\u0005\u001dr/C\u0002\u0002*Q\u0011aa\u00149uS>t\u0007bBA\t\u0003?\u0001\r\u0001\u001b\t\u0004S\u0005=B!B\u0016W\u0005\u0004a\u0003cA\u0015\u00024\u0011)QG\u0016b\u0001Y!)!P\u0016a\u0001w\u0002")
public class Cache<K, V> {
    private final Queue<K> queue;
    private final Map<K, V> map;
    private final int maxCapacity;

    public static <K, V> Cache<K, V> newImmutableCache(int n) {
        return Cache$.MODULE$.newImmutableCache(n);
    }

    public static <K, V> LoadingCache<K, V> newConcurrentLoadingCache(long l, Function1<K, V> function1) {
        return Cache$.MODULE$.newConcurrentLoadingCache(l, function1);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentCache(long l) {
        return Cache$.MODULE$.newConcurrentCache(l);
    }

    public Cache<K, V> put(K key, V value) {
        Cache cache;
        if (this.map.get(key).contains(value)) {
            cache = this;
        } else if (this.map.size() == this.maxCapacity) {
            Tuple2 tuple2 = this.queue.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object removedKey = tuple2._1();
            Queue newQueue = (Queue)tuple2._2();
            Tuple2 tuple22 = new Tuple2(removedKey, (Object)newQueue);
            Tuple2 tuple23 = tuple22;
            Object removedKey2 = tuple23._1();
            Queue newQueue2 = (Queue)tuple23._2();
            Map newMap = ((Map)this.map.$minus(removedKey2)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
            cache = new Cache<K, V>(newQueue2.enqueue(key), newMap, this.maxCapacity);
        } else {
            Queue newQueue = this.queue.enqueue(key);
            Map newMap = this.map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
            cache = new Cache<K, V>(newQueue, newMap, this.maxCapacity);
        }
        return cache;
    }

    public Cache<K, V> remove(K key) {
        Cache cache;
        if (this.map.contains(key)) {
            Queue newQueue = (Queue)this.queue.filter((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Cache.$anonfun$remove$1(key, x$2)));
            Map newMap = (Map)this.map.$minus(key);
            cache = new Cache<K, V>(newQueue, newMap, this.maxCapacity);
        } else {
            cache = this;
        }
        return cache;
    }

    public Option<V> get(K key) {
        return this.map.get(key);
    }

    public static final /* synthetic */ boolean $anonfun$remove$1(Object key$1, Object x$2) {
        return !BoxesRunTime.equals((Object)x$2, (Object)key$1);
    }

    public Cache(Queue<K> queue, Map<K, V> map, int maxCapacity) {
        this.queue = queue;
        this.map = map;
        this.maxCapacity = maxCapacity;
    }
}

