/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import io.gatling.core.config.Credentials;
import io.gatling.jms.JmsDestination;
import io.gatling.jms.JmsMessageMatcher;
import io.gatling.jms.JmsQueue;
import io.gatling.jms.JmsTemporaryQueue$;
import io.gatling.jms.JmsTemporaryTopic$;
import io.gatling.jms.JmsTopic;
import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001-\u0011qbU5na2,'*\\:DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\taa\u00197jK:$(BA\u0003\u0007\u0003\rQWn\u001d\u0006\u0003\u000f!\tqaZ1uY&twMC\u0001\n\u0003\tIwn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'qi\u0011\u0001\u0006\u0006\u0003+Y\tQa\u001d7gi)T!a\u0006\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eQ\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\t1aY8n\u0013\tiBCA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005)2m\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=OC6,\u0007CA\u0011%\u001d\ti!%\u0003\u0002$\u001d\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019c\u0002\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\u0005)ZS\"\u0001\u0003\n\u00051\"!A\u0004&ng\u0012+7\u000f^5oCRLwN\u001c\u0005\t]\u0001\u0011\t\u0011)A\u0005S\u0005\u0001\"/\u001a9ms\u0012+7\u000f^5oCRLwN\u001c\u0005\ta\u0001\u0011\t\u0011)A\u0005A\u0005\u0019QO\u001d7\t\u0011I\u0002!\u0011!Q\u0001\nM\n1b\u0019:fI\u0016tG/[1mgB\u0019Q\u0002\u000e\u001c\n\u0005Ur!AB(qi&|g\u000e\u0005\u00028y5\t\u0001H\u0003\u0002:u\u000511m\u001c8gS\u001eT!a\u000f\u0004\u0002\t\r|'/Z\u0005\u0003{a\u00121b\u0011:fI\u0016tG/[1mg\"Aq\b\u0001B\u0001B\u0003%\u0001%\u0001\bd_:$X\r\u001f;GC\u000e$xN]=\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000bA\u0002Z3mSZ,'/_'pI\u0016\u0004\"!D\"\n\u0005\u0011s!aA%oi\"Aa\t\u0001B\u0001B\u0003%q)\u0001\bnKN\u001c\u0018mZ3NCR\u001c\u0007.\u001a:\u0011\u0005)B\u0015BA%\u0005\u0005EQUn]'fgN\fw-Z'bi\u000eDWM\u001d\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00135{\u0005+\u0015*T)V3\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u0010K\u0001\u0004\u0001\u0003\"\u0002\u0015K\u0001\u0004I\u0003\"\u0002\u0018K\u0001\u0004I\u0003\"\u0002\u0019K\u0001\u0004\u0001\u0003\"\u0002\u001aK\u0001\u0004\u0019\u0004\"B K\u0001\u0004\u0001\u0003\"B!K\u0001\u0004\u0011\u0005\"\u0002$K\u0001\u00049\u0005b\u0002-\u0001\u0005\u0004%\t!W\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u0001.\u0011\tm\u0003\u0007\u0005I\u0007\u00029*\u0011QLX\u0001\u0005kRLGNC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005d&!\u0003%bg\"$\u0018M\u00197f\u0011\u0019\u0019\u0007\u0001)A\u00055\u0006Y\u0001O]8qKJ$\u0018.Z:!\u0011\u001d)\u0007A1A\u0005\u0002\u0019\f1a\u0019;y+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0019q\u0017-\\5oO*\tA.A\u0003kCZ\f\u00070\u0003\u0002oS\nq\u0011J\\5uS\u0006d7i\u001c8uKb$\bB\u00029\u0001A\u0003%q-\u0001\u0003dib\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta]\u0001\u0004c\u000e4W#\u0001;\u0011\u0005U<X\"\u0001<\u000b\u0005\u0015Y\u0017B\u0001=w\u0005E\u0019uN\u001c8fGRLwN\u001c$bGR|'/\u001f\u0005\u0007u\u0002\u0001\u000b\u0011\u0002;\u0002\tE\u001cg\r\t\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0003\u0011\u0019wN\u001c8\u0016\u0003y\u0004\"!^@\n\u0007\u0005\u0005aO\u0001\u0006D_:tWm\u0019;j_:Dq!!\u0002\u0001A\u0003%a0A\u0003d_:t\u0007\u0005C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f\u000591/Z:tS>tWCAA\u0007!\r)\u0018qB\u0005\u0004\u0003#1(aB*fgNLwN\u001c\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u000e\u0005A1/Z:tS>t\u0007\u0005C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u001c\u0005\u0019\"/\u001a9ms*k7\u000fR3ti&t\u0017\r^5p]V\u0011\u0011Q\u0004\t\u0004k\u0006}\u0011bAA\u0011m\nYA)Z:uS:\fG/[8o\u0011!\t)\u0003\u0001Q\u0001\n\u0005u\u0011\u0001\u0006:fa2L(*\\:EKN$\u0018N\\1uS>t\u0007\u0005C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002,\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002.A\u0019Q/a\f\n\u0007\u0005EbOA\bNKN\u001c\u0018mZ3Qe>$WoY3s\u0011!\t)\u0004\u0001Q\u0001\n\u00055\u0012!\u00039s_\u0012,8-\u001a:!\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\t\u0011c\u0019:fCR,G)Z:uS:\fG/[8o)\u0011\ti\"!\u0010\t\r!\n9\u00041\u0001*\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\n1c\u0019:fCR,'+\u001a9ms\u000e{gn];nKJ$B!!\u0012\u0002LA\u0019Q/a\u0012\n\u0007\u0005%cOA\bNKN\u001c\u0018mZ3D_:\u001cX/\\3s\u0011%\ti%a\u0010\u0011\u0002\u0003\u0007\u0001%\u0001\u0005tK2,7\r^8s\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\n1c\u001e:ji\u0016\u0004&o\u001c9t)>lUm]:bO\u0016$b!!\u0016\u0002\\\u0005-\u0004cA\u0007\u0002X%\u0019\u0011\u0011\f\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003;\ny\u00051\u0001\u0002`\u0005)\u0001O]8qgB1\u0011%!\u0019!\u0003KJ1!a\u0019'\u0005\ri\u0015\r\u001d\t\u0004\u001b\u0005\u001d\u0014bAA5\u001d\t\u0019\u0011I\\=\t\u0011\u00055\u0014q\na\u0001\u0003_\nq!\\3tg\u0006<W\rE\u0002v\u0003cJ1!a\u001dw\u0005\u001diUm]:bO\u0016Dq!a\u001e\u0001\t\u0003\tI(\u0001\ttK:$')\u001f;fg6+7o]1hKR1\u0011qNA>\u0003\u0017C\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\u0006Ef$Xm\u001d\t\u0006\u001b\u0005\u0005\u0015QQ\u0005\u0004\u0003\u0007s!!B!se\u0006L\bcA\u0007\u0002\b&\u0019\u0011\u0011\u0012\b\u0003\t\tKH/\u001a\u0005\t\u0003;\n)\b1\u0001\u0002`!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0015AD:f]\u0012l\u0015\r]'fgN\fw-\u001a\u000b\u0007\u0003_\n\u0019*a&\t\u0011\u0005U\u0015Q\u0012a\u0001\u0003?\n1!\\1q\u0011!\ti&!$A\u0002\u0005}\u0003bBAN\u0001\u0011\u0005\u0011QT\u0001\u0012g\u0016tGm\u00142kK\u000e$X*Z:tC\u001e,GCBA8\u0003?\u000bi\u000b\u0003\u0005\u0002\"\u0006e\u0005\u0019AAR\u0003\u0005y\u0007\u0003BAS\u0003Sk!!a*\u000b\u0005%q\u0016\u0002BAV\u0003O\u0013AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"!\u0018\u0002\u001a\u0002\u0007\u0011q\f\u0005\b\u0003c\u0003A\u0011AAZ\u0003=\u0019XM\u001c3UKb$X*Z:tC\u001e,GCBA8\u0003k\u000bI\fC\u0004\u00028\u0006=\u0006\u0019\u0001\u0011\u0002\u00175,7o]1hKR+\u0007\u0010\u001e\u0005\t\u0003;\ny\u000b1\u0001\u0002`!9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0016aC:f]\u0012lUm]:bO\u0016$B!a\u001c\u0002B\"A\u0011QNA^\u0001\u0004\ty\u0007C\u0004\u0002F\u0002!\t!a2\u0002\u000b\rdwn]3\u0015\u0005\u0005U\u0003\"CAf\u0001E\u0005I\u0011AAg\u0003u\u0019'/Z1uKJ+\u0007\u000f\\=D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\nTCAAhU\r\u0001\u0013\u0011[\u0016\u0003\u0003'\u0004B!!6\u0002`6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001c\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0006]'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SimpleJmsClient
implements StrictLogging {
    private final JmsMessageMatcher messageMatcher;
    private final Hashtable<String, String> properties;
    private final InitialContext ctx;
    private final ConnectionFactory qcf;
    private final Connection conn;
    private final Session session;
    private final Destination replyJmsDestination;
    private final MessageProducer producer;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Hashtable<String, String> properties() {
        return this.properties;
    }

    public InitialContext ctx() {
        return this.ctx;
    }

    public ConnectionFactory qcf() {
        return this.qcf;
    }

    public Connection conn() {
        return this.conn;
    }

    public Session session() {
        return this.session;
    }

    public Destination replyJmsDestination() {
        return this.replyJmsDestination;
    }

    public MessageProducer producer() {
        return this.producer;
    }

    private Destination createDestination(JmsDestination destination) {
        JmsDestination jmsDestination;
        block6: {
            Queue queue;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            jmsDestination = destination;
                            if (!(jmsDestination instanceof JmsQueue)) break block2;
                            JmsQueue jmsQueue = (JmsQueue)jmsDestination;
                            String name = jmsQueue.name();
                            queue = this.session().createQueue(name);
                            break block3;
                        }
                        if (!(jmsDestination instanceof JmsTopic)) break block4;
                        JmsTopic jmsTopic = (JmsTopic)jmsDestination;
                        String name = jmsTopic.name();
                        queue = this.session().createTopic(name);
                        break block3;
                    }
                    JmsTemporaryQueue$ jmsTemporaryQueue$ = JmsTemporaryQueue$.MODULE$;
                    JmsDestination jmsDestination2 = jmsDestination;
                    if (jmsTemporaryQueue$ != null ? !jmsTemporaryQueue$.equals(jmsDestination2) : jmsDestination2 != null) break block5;
                    queue = this.session().createTemporaryQueue();
                    break block3;
                }
                JmsTemporaryTopic$ jmsTemporaryTopic$ = JmsTemporaryTopic$.MODULE$;
                JmsDestination jmsDestination3 = jmsDestination;
                if (jmsTemporaryTopic$ != null ? !jmsTemporaryTopic$.equals(jmsDestination3) : jmsDestination3 != null) break block6;
                queue = this.session().createTemporaryTopic();
            }
            return queue;
        }
        throw new MatchError((Object)jmsDestination);
    }

    public MessageConsumer createReplyConsumer(String selector) {
        return this.conn().createSession(false, 1).createConsumer(this.replyJmsDestination(), selector);
    }

    public String createReplyConsumer$default$1() {
        return null;
    }

    private void writePropsToMessage(Map<String, Object> props, Message message) {
        props.foreach((Function1)new scala.Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final Message message$1;

            public final void apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    this.message$1.setObjectProperty(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.message$1 = message$1;
            }
        });
    }

    public Message sendBytesMessage(byte[] bytes, Map<String, Object> props) {
        BytesMessage message = this.session().createBytesMessage();
        message.writeBytes(bytes);
        this.writePropsToMessage(props, (Message)message);
        return this.sendMessage((Message)message);
    }

    public Message sendMapMessage(Map<String, Object> map, Map<String, Object> props) {
        MapMessage message = this.session().createMapMessage();
        map.foreach((Function1)new scala.Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final MapMessage message$2;

            public final void apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    this.message$2.setObject(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.message$2 = message$2;
            }
        });
        this.writePropsToMessage(props, (Message)message);
        return this.sendMessage((Message)message);
    }

    public Message sendObjectMessage(Serializable o, Map<String, Object> props) {
        ObjectMessage message = this.session().createObjectMessage(o);
        this.writePropsToMessage(props, (Message)message);
        return this.sendMessage((Message)message);
    }

    public Message sendTextMessage(String messageText, Map<String, Object> props) {
        TextMessage message = this.session().createTextMessage(messageText);
        this.writePropsToMessage(props, (Message)message);
        return this.sendMessage((Message)message);
    }

    public Message sendMessage(Message message) {
        message.setJMSReplyTo(this.replyJmsDestination());
        this.messageMatcher.prepareRequest(message);
        this.producer().send(message);
        return message;
    }

    public void close() {
        this.producer().close();
        this.session().close();
        this.conn().stop();
    }

    public SimpleJmsClient(String connectionFactoryName, JmsDestination destination, JmsDestination replyDestination, String url, Option<Credentials> credentials, String contextFactory, int deliveryMode, JmsMessageMatcher messageMatcher) {
        this.messageMatcher = messageMatcher;
        StrictLogging.class.$init$((StrictLogging)this);
        this.properties = new Hashtable();
        this.properties().put("java.naming.factory.initial", contextFactory);
        this.properties().put("java.naming.provider.url", url);
        credentials.foreach((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleJmsClient $outer;

            public final String apply(Credentials credentials) {
                this.$outer.properties().put("java.naming.security.principal", credentials.username());
                return this.$outer.properties().put("java.naming.security.credentials", credentials.password());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.ctx = new InitialContext(this.properties());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got InitialContext ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ctx()})));
        }
        this.qcf = (ConnectionFactory)this.ctx().lookup(connectionFactoryName);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ConnectionFactory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qcf()})));
        }
        this.conn = this.qcf().createConnection();
        this.conn().start();
        this.session = this.conn().createSession(false, 1);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got Connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conn()})));
        }
        this.replyJmsDestination = this.createDestination(replyDestination);
        this.producer = this.session().createProducer(this.createDestination(destination));
        this.producer().setDeliveryMode(deliveryMode);
    }
}

