/**
 * Copyright 2011-2014 eBusiness Information, Groupe Excilys (www.ebusinessinformation.fr)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gatling.jms.check

import java.io.StringReader
import javax.jms.{ Message, TextMessage }

import com.typesafe.scalalogging.slf4j.StrictLogging
import io.gatling.core.check._
import io.gatling.core.check.extractor.xpath._
import io.gatling.core.validation.{ FailureWrapper, SuccessWrapper, Validation }
import io.gatling.jms.JmsCheck
import org.xml.sax.InputSource

object JmsXPathCheckBuilder extends XPathCheckBuilder[JmsCheck, Message] with StrictLogging {

  def preparer[T](f: InputSource => T)(message: Message): Validation[Option[T]] =
    try {
      message match {
        case tm: TextMessage => Some(f(new InputSource(new StringReader(tm.getText)))).success
        case _               => "Unsupported message type".failure
      }
    } catch {
      case e: Exception =>
        val message = s"Could not parse response into a DOM Document: ${e.getMessage}"
        logger.info(message, e)
        message.failure
    }

  val CheckBuilder: Extender[JmsCheck, Message] = (wrapped: Check[Message]) => wrapped
}
