/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.its;

import io.gatling.recorder.internal.bouncycastle.its.ETSIEncryptedData;
import io.gatling.recorder.internal.bouncycastle.its.ETSIRecipientInfoBuilder;
import io.gatling.recorder.internal.bouncycastle.its.operator.ETSIDataEncryptor;
import io.gatling.recorder.internal.bouncycastle.oer.its.ieee1609dot2.AesCcmCiphertext;
import io.gatling.recorder.internal.bouncycastle.oer.its.ieee1609dot2.EncryptedData;
import io.gatling.recorder.internal.bouncycastle.oer.its.ieee1609dot2.SequenceOfRecipientInfo;
import io.gatling.recorder.internal.bouncycastle.oer.its.ieee1609dot2.SymmetricCiphertext;
import java.util.ArrayList;
import java.util.List;

public class ETSIEncryptedDataBuilder {
    private final List<ETSIRecipientInfoBuilder> recipientInfoBuilders = new ArrayList<ETSIRecipientInfoBuilder>();

    public void addRecipientInfoBuilder(ETSIRecipientInfoBuilder eTSIRecipientInfoBuilder) {
        this.recipientInfoBuilders.add(eTSIRecipientInfoBuilder);
    }

    public ETSIEncryptedData build(ETSIDataEncryptor eTSIDataEncryptor, byte[] byArray) {
        byte[] byArray2 = eTSIDataEncryptor.encrypt(byArray);
        byte[] byArray3 = eTSIDataEncryptor.getKey();
        byte[] byArray4 = eTSIDataEncryptor.getNonce();
        SequenceOfRecipientInfo.Builder builder = SequenceOfRecipientInfo.builder();
        for (ETSIRecipientInfoBuilder eTSIRecipientInfoBuilder : this.recipientInfoBuilders) {
            builder.addRecipients(eTSIRecipientInfoBuilder.build(byArray3));
        }
        return new ETSIEncryptedData(EncryptedData.builder().setRecipients(builder.createSequenceOfRecipientInfo()).setCiphertext(SymmetricCiphertext.aes128ccm(AesCcmCiphertext.builder().setCcmCiphertext(byArray2).setNonce(byArray4).createAesCcmCiphertext())).createEncryptedData());
    }
}

