/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.cmce;

import io.gatling.recorder.internal.bouncycastle.crypto.SecretWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.jcajce.spec.KEMExtractSpec;
import io.gatling.recorder.internal.bouncycastle.jcajce.spec.KEMGenerateSpec;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.cmce.CMCEKEMExtractor;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.cmce.CMCEKEMGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPublicKey;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class CMCEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCCMCEPublicKey bCCMCEPublicKey = (BCCMCEPublicKey)this.genSpec.getPublicKey();
            CMCEKEMGenerator cMCEKEMGenerator = new CMCEKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = cMCEKEMGenerator.generateEncapsulated(bCCMCEPublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCCMCEPrivateKey bCCMCEPrivateKey = (BCCMCEPrivateKey)this.extSpec.getPrivateKey();
        CMCEKEMExtractor cMCEKEMExtractor = new CMCEKEMExtractor(bCCMCEPrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = cMCEKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

