/*
 * Decompiled with CFR 0.152.
 */
package coursier.internal;

import coursier.internal.FileUtil$Java6$;
import coursier.internal.FileUtil$Java7$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class FileUtil$ {
    public static FileUtil$ MODULE$;
    private volatile Option<Object> java7AvailableOpt;

    static {
        new FileUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean versionGteq(String version, Tuple2<Object, Object> to) {
        Option[] optionArray = (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(version)).split('.'))).take(2))).map((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)));
        Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
        if (option.isEmpty()) return false;
        if (option.get() == null) return false;
        if (((SeqLike)option.get()).lengthCompare(2) != 0) return false;
        Option option2 = (Option)((SeqLike)option.get()).apply(0);
        Option option3 = (Option)((SeqLike)option.get()).apply(1);
        if (!(option2 instanceof Some)) return false;
        Some some = (Some)option2;
        int major = BoxesRunTime.unboxToInt((Object)some.value());
        if (!(option3 instanceof Some)) return false;
        Some some2 = (Some)option3;
        int minor = BoxesRunTime.unboxToInt((Object)some2.value());
        return package$.MODULE$.Ordering().apply(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).gteq((Object)new Tuple2.mcII.sp(major, minor), (Object)new Tuple2.mcII.sp(1, 7));
    }

    private Option<Object> java7AvailableOpt() {
        return this.java7AvailableOpt;
    }

    private void java7AvailableOpt_$eq(Option<Object> x$1) {
        this.java7AvailableOpt = x$1;
    }

    private boolean java7Available() {
        return BoxesRunTime.unboxToBoolean((Object)this.java7AvailableOpt().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            void var0;
            boolean available = scala.sys.package$.MODULE$.props().get("java.version").exists((Function1 & Serializable & scala.Serializable)version -> BoxesRunTime.boxToBoolean((boolean)FileUtil$.MODULE$.versionGteq(version, (Tuple2<Object, Object>)new Tuple2.mcII.sp(1, 7))));
            MODULE$.java7AvailableOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)available)));
            return (boolean)var0;
        }));
    }

    public void atomicMove(File from, File to) {
        if (this.java7Available()) {
            FileUtil$Java7$.MODULE$.atomicMove(from, to);
        } else {
            FileUtil$Java6$.MODULE$.move(from, to);
        }
    }

    public void write(File file, byte[] bytes) {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
        }
    }

    private byte[] readFully(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
        int nRead = 0;
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public byte[] readAllBytes(File file) {
        byte[] byArray;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            byArray = this.readFully(fis);
        }
        return byArray;
    }

    public File createTempDirectory(String prefix) {
        return this.java7Available() ? FileUtil$Java7$.MODULE$.createTempDirectory(prefix) : FileUtil$Java6$.MODULE$.createTempDirectory(prefix);
    }

    private FileUtil$() {
        MODULE$ = this;
        this.java7AvailableOpt = Option$.MODULE$.empty();
    }
}

