/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache.internal;

import coursier.cache.ArtifactError;
import coursier.cache.ArtifactError$NotFound$;
import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.CachePolicy;
import coursier.cache.CacheUrl$;
import coursier.cache.ConnectionBuilder$;
import coursier.cache.internal.Downloader;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import coursier.util.Artifact;
import coursier.util.Sync;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Downloader$
implements scala.Serializable {
    public static Downloader$ MODULE$;
    private final Seq<String> coursier$cache$internal$Downloader$$checksumHeader;

    static {
        new Downloader$();
    }

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return this.coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        return this.helper$2(sslRetry, url, f);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left left;
        block10: {
            URLConnection conn = null;
            try {
                Left left2;
                URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option len = new Some((Object)BoxesRunTime.boxToLong((long)httpURLConnection.getContentLengthLong())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$21 -> x$21 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, (Option<Object>)len);
                        right = package$.MODULE$.Right().apply((Object)len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, (Option<Object>)None$.MODULE$);
                        }
                    }
                    left2 = right;
                } else {
                    left2 = package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), (Option<Throwable>)None$.MODULE$));
                }
                left = left2;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.bufferSize(), S);
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, S);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$10, Function0 f$1) {
        Either res;
        Some some;
        block8: {
            while (true) {
                Some resOpt;
                Some some2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0 & Serializable & scala.Serializable)() -> {
                        Either either;
                        try {
                            either = (Either)f$1.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left = package$.MODULE$.Left().apply((Object)new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            either = left;
                        }
                        return either;
                    });
                    Either res2 = (Either)res0.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ArtifactError.ConcurrentDownload(url$10)));
                    some2 = new Some((Object)res2);
                }
                catch (Throwable throwable) {
                    None$ none$;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        none$ = None$.MODULE$;
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$20 -> new StringBuilder(3).append(" (").append((String)x$20).append(")").toString())).append(" while downloading ").append(url$10).toString(), (Option<Throwable>)new Some((Object)e));
                            if (Boolean.getBoolean("coursier.cache.throw-exceptions")) {
                                throw ex;
                            }
                            none$ = new Some((Object)package$.MODULE$.Left().apply((Object)ex));
                        } else {
                            throw throwable;
                        }
                    }
                    some2 = none$;
                }
                some = resOpt = some2;
                if (some instanceof Some) break block8;
                if (!None$.MODULE$.equals(some)) break;
                --retry;
            }
            throw new MatchError((Object)some);
        }
        Some some3 = some;
        Either either = res = (Either)some3.value();
        return either;
    }

    private Downloader$() {
        MODULE$ = this;
        this.coursier$cache$internal$Downloader$$checksumHeader = (Seq)new .colon.colon((Object)"MD5", (List)new .colon.colon((Object)"SHA1", (List)new .colon.colon((Object)"SHA256", (List)Nil$.MODULE$)));
    }
}

