/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.DriverCapabilities;
import io.github.bonigarcia.seljup.DriverUrl;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsReader {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;

    public AnnotationsReader(Config config) {
        this.config = config;
    }

    public Optional<Capabilities> getCapabilities(Parameter parameter, Optional<Object> testInstance) throws IllegalAccessException {
        Optional<Capabilities> out = Optional.empty();
        DriverCapabilities driverCapabilities = parameter.getAnnotation(DriverCapabilities.class);
        DesiredCapabilities capabilities = null;
        if (driverCapabilities != null) {
            capabilities = new DesiredCapabilities();
            for (String capability : driverCapabilities.value()) {
                Optional<List<Object>> keyValue = this.getKeyValue(capability);
                if (!keyValue.isPresent()) continue;
                capabilities.setCapability(keyValue.get().get(0).toString(), keyValue.get().get(1));
            }
            out = Optional.of(capabilities);
        } else {
            Optional<Object> annotatedField = this.seekFieldAnnotatedWith(testInstance, DriverCapabilities.class);
            if (annotatedField.isPresent()) {
                capabilities = (Capabilities)annotatedField.get();
                out = Optional.of(capabilities);
            }
        }
        return out;
    }

    public Optional<URL> getUrl(Parameter parameter, Optional<Object> testInstance) throws MalformedURLException, IllegalAccessException {
        Optional<URL> out = Optional.empty();
        String seleniumServerUrl = this.getConfig().getSeleniumServerUrl();
        if (seleniumServerUrl != null && !seleniumServerUrl.isEmpty()) {
            out = Optional.of(new URL(seleniumServerUrl));
        } else {
            String urlValue = null;
            DriverUrl driverUrl = parameter.getAnnotation(DriverUrl.class);
            if (driverUrl != null) {
                urlValue = driverUrl.value();
                out = Optional.of(new URL(urlValue));
            } else {
                Optional<Object> annotatedField = this.seekFieldAnnotatedWith(testInstance, DriverUrl.class);
                if (annotatedField.isPresent()) {
                    urlValue = (String)annotatedField.get();
                    out = Optional.of(new URL(urlValue));
                }
            }
        }
        return out;
    }

    public boolean isBoolean(String s) {
        boolean isBool;
        boolean bl = isBool = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
        if (!isBool) {
            this.log.trace("Value {} is not boolean", (Object)s);
        }
        return isBool;
    }

    public boolean isNumeric(String s) {
        boolean numeric = StringUtils.isNumeric((CharSequence)s);
        if (!numeric) {
            this.log.trace("Value {} is not numeric", (Object)s);
        }
        return numeric;
    }

    public Object getOptionsFromAnnotatedField(Optional<Object> testInstance, Class<Options> annotationClass) throws IllegalAccessException {
        Object out = null;
        Optional annotatedField = AnnotationsReader.seekFieldAnnotatedWith(testInstance, annotationClass, null);
        if (annotatedField.isPresent()) {
            out = annotatedField.get();
        }
        return out;
    }

    public <T extends Capabilities> T getOptionsFromAnnotatedField(Optional<Object> testInstance, Class<Options> annotationClass, Class<T> capabilitiesClass) throws IllegalAccessException {
        if (capabilitiesClass == null) {
            throw new SeleniumJupiterException("The parameter capabilitiesClass must not be null.");
        }
        return (T)((Capabilities)AnnotationsReader.seekFieldAnnotatedWith(testInstance, annotationClass, capabilitiesClass).orElse(null));
    }

    public Optional<Object> seekFieldAnnotatedWith(Optional<Object> testInstance, Class<? extends Annotation> annotation) throws IllegalAccessException {
        return AnnotationsReader.seekFieldAnnotatedWith(testInstance, annotation, null);
    }

    private static <T> Optional<T> seekFieldAnnotatedWith(Optional<Object> testInstance, Class<? extends Annotation> annotation, Class<T> annotatedType) throws IllegalAccessException {
        Object object;
        Class<?> clazz;
        Optional out = Optional.empty();
        if (testInstance.isPresent() && !(out = AnnotationsReader.getField(annotation, annotatedType, clazz = (object = testInstance.get()).getClass(), object)).isPresent()) {
            Class<?> superclass;
            while ((superclass = clazz.getSuperclass()) != Object.class && !(out = AnnotationsReader.getField(annotation, annotatedType, superclass, object)).isPresent()) {
                clazz = clazz.getSuperclass();
            }
        }
        return out;
    }

    private static <T> Optional<T> getField(Class<? extends Annotation> annotation, Class<T> annotatedType, Class<? extends Object> clazz, Object object) throws IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation) || annotatedType != null && annotatedType != field.getType()) continue;
            field.setAccessible(true);
            if (annotatedType != null) {
                return Optional.of(annotatedType.cast(field.get(object)));
            }
            return Optional.of(field.get(object));
        }
        return Optional.empty();
    }

    public Optional<DockerBrowser> getDocker(Parameter parameter) {
        Optional<DockerBrowser> out = Optional.empty();
        DockerBrowser dockerBrowser = parameter.getAnnotation(DockerBrowser.class);
        if (dockerBrowser != null) {
            out = Optional.of(dockerBrowser);
        }
        return out;
    }

    public Optional<List<Object>> getKeyValue(String keyValue) {
        StringTokenizer st = new StringTokenizer(keyValue, "=");
        if (st.countTokens() != 2) {
            this.log.warn("Invalid format in {} (expected key=value)", (Object)keyValue);
            return Optional.empty();
        }
        String key = st.nextToken();
        String value = st.nextToken();
        Object returnedValue = value;
        if (this.isBoolean(value)) {
            returnedValue = new Boolean(value);
        } else if (this.isNumeric(value)) {
            returnedValue = new Integer(value);
        }
        return Optional.of(Arrays.asList(key, returnedValue));
    }

    public Config getConfig() {
        return this.config;
    }
}

