/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.BrowsersTemplate;

public class BrowserBuilder {
    String type;
    String version;
    String browserName;
    String deviceName;
    String url;

    private BrowserBuilder(String type) {
        this.type = type;
    }

    public static BrowserBuilder chrome() {
        return new BrowserBuilder("chrome");
    }

    public static BrowserBuilder firefox() {
        return new BrowserBuilder("firefox");
    }

    public static BrowserBuilder edge() {
        return new BrowserBuilder("edge");
    }

    public static BrowserBuilder opera() {
        return new BrowserBuilder("opera");
    }

    public static BrowserBuilder safari() {
        return new BrowserBuilder("safari");
    }

    public static BrowserBuilder appium() {
        return new BrowserBuilder("appium");
    }

    public static BrowserBuilder phantomjs() {
        return new BrowserBuilder("phantomjs");
    }

    public static BrowserBuilder iexplorer() {
        return new BrowserBuilder("iexplorer");
    }

    public static BrowserBuilder chromeInDocker() {
        return new BrowserBuilder("chrome-in-docker");
    }

    public static BrowserBuilder firefoxInDocker() {
        return new BrowserBuilder("firefox-in-docker");
    }

    public static BrowserBuilder operaInDocker() {
        return new BrowserBuilder("opera-in-docker");
    }

    public static BrowserBuilder android() {
        return new BrowserBuilder("android");
    }

    public BrowserBuilder version(String version) {
        this.version = version;
        return this;
    }

    public BrowserBuilder browserName(String browserName) {
        this.browserName = browserName;
        return this;
    }

    public BrowserBuilder deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public BrowserBuilder url(String url) {
        this.url = url;
        return this;
    }

    public BrowsersTemplate.Browser build() {
        return new BrowsersTemplate.Browser(this.type, this.version, this.browserName, this.deviceName, this.url);
    }
}

