/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.ChromeDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import io.github.bonigarcia.seljup.handler.FirefoxDriverHandler;
import io.github.bonigarcia.seljup.handler.OperaDriverHandler;
import java.lang.invoke.MethodHandles;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserInstance {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    BrowserType browserType;
    String dockerImage;
    String path;
    DriverHandler driverHandler;
    String optionsKey;
    DesiredCapabilities capabilities;

    public BrowserInstance(Config config, BrowserType browserType) {
        this.config = config;
        this.browserType = browserType;
        switch (browserType) {
            case ANDROID: {
                this.driverHandler = new ChromeDriverHandler(config);
                this.optionsKey = "goog:chromeOptions";
                this.capabilities = new DesiredCapabilities();
                break;
            }
            case FIREFOX: {
                this.dockerImage = config.getFirefoxImageFormat();
                this.path = config.getFirefoxPath();
                this.driverHandler = new FirefoxDriverHandler(config);
                this.optionsKey = "moz:firefoxOptions";
                this.capabilities = new DesiredCapabilities("firefox", "", Platform.ANY);
                break;
            }
            case OPERA: {
                this.dockerImage = config.getOperaImageFormat();
                this.path = config.getOperaPath();
                this.driverHandler = new OperaDriverHandler(config);
                this.optionsKey = "operaOptions";
                this.capabilities = new DesiredCapabilities("operablink", "", Platform.ANY);
                break;
            }
            default: {
                this.dockerImage = config.getChromeImageFormat();
                this.path = config.getChromePath();
                this.driverHandler = new ChromeDriverHandler(config);
                this.optionsKey = "goog:chromeOptions";
                this.capabilities = new DesiredCapabilities("chrome", "", Platform.ANY);
            }
        }
    }

    public String getNextVersion(String version, String latestVersion) {
        int iVersion = version.indexOf(46);
        iVersion = iVersion != -1 ? iVersion : version.length();
        int nextVersionInt = Integer.parseInt(version.substring(0, iVersion)) + 1;
        int iLatestVersion = latestVersion.indexOf(46);
        int latestVersionInt = Integer.parseInt(latestVersion.substring(0, iLatestVersion = iLatestVersion != -1 ? iLatestVersion : latestVersion.length())) + 1;
        if (nextVersionInt > latestVersionInt) {
            return null;
        }
        return String.valueOf(nextVersionInt) + ".0";
    }

    public String getPath() {
        return this.path;
    }

    public DriverHandler getDriverHandler() {
        return this.driverHandler;
    }

    public String getOptionsKey() {
        return this.optionsKey;
    }

    public String getDockerImage(String version) {
        return String.format(this.getDockerImage(), version);
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public String getBrowserName() {
        return this.browserType.name();
    }
}

