/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.annotations.SerializedName;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.DockerHubService;
import io.github.bonigarcia.seljup.DockerHubTags;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.VersionComparator;
import io.github.bonigarcia.seljup.config.Config;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBrowserConfig {
    final transient Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final transient String VERSION_SUFFIX = ".0";
    static final transient String LATEST = "latest";
    BrowserConfig chrome;
    BrowserConfig firefox;
    BrowserConfig operablink;
    transient Config config;
    transient String version;
    transient InternalPreferences preferences;

    public DockerBrowserConfig(List<String> envs, Config config, BrowserInstance browserInstance, String label) {
        boolean isUnstable;
        this.config = config;
        this.preferences = new InternalPreferences(config);
        boolean isLatest = label == null || label.isEmpty() || label.equalsIgnoreCase(LATEST);
        boolean isBeta = label != null && label.equalsIgnoreCase("beta");
        boolean bl = isUnstable = label != null && label.equalsIgnoreCase("unstable");
        this.version = isLatest ? this.getLatestVersion(browserInstance) : (label.startsWith(LATEST) ? this.getVersionFromLabel(browserInstance, label) : (!isBeta && !isUnstable && !label.endsWith(VERSION_SUFFIX) ? label + VERSION_SUFFIX : label));
        Browser browser = this.getBrowser(envs, browserInstance, isBeta, isUnstable);
        switch (browserInstance.getBrowserType()) {
            case FIREFOX: {
                this.firefox = new BrowserConfig(this.version);
                this.firefox.addBrowser(this.version, browser);
                break;
            }
            case OPERA: {
                this.operablink = new BrowserConfig(this.version);
                this.operablink.addBrowser(this.version, browser);
                break;
            }
            default: {
                this.chrome = new BrowserConfig(this.version);
                this.chrome.addBrowser(this.version, browser);
            }
        }
    }

    private Browser getBrowser(List<String> envs, BrowserInstance browserInstance, boolean isBeta, boolean isUnstable) {
        String dockerImage = String.format(browserInstance.getDockerImage(), this.version);
        String path = browserInstance.getPath();
        BrowserType browserType = browserInstance.getBrowserType();
        if (isBeta && browserType == BrowserType.CHROME) {
            dockerImage = this.getConfig().getChromeBetaImage();
            path = this.getConfig().getChromeBetaPath();
        } else if (isUnstable && browserType == BrowserType.CHROME) {
            dockerImage = this.getConfig().getChromeUnstableImage();
            path = this.getConfig().getChromeUnstablePath();
        } else if (isBeta && browserType == BrowserType.FIREFOX) {
            dockerImage = this.getConfig().getFirefoxBetaImage();
            path = this.getConfig().getFirefoxBetaPath();
        } else if (isUnstable && browserType == BrowserType.FIREFOX) {
            dockerImage = this.getConfig().getFirefoxUnstableImage();
            path = this.getConfig().getFirefoxUnstablePath();
        }
        return new Browser(dockerImage, path, envs);
    }

    private String getLatestVersion(BrowserInstance browserInstance) {
        String latestVersion = null;
        if (this.config.isBrowserListFromDockerHub()) {
            boolean versionInPreferences;
            String key = browserInstance.getBrowserName();
            boolean bl = versionInPreferences = this.getConfig().isUsePreferences() && this.preferences.checkKeyInPreferences(key);
            if (versionInPreferences) {
                latestVersion = this.preferences.getValueFromPreferences(key);
            } else {
                try {
                    latestVersion = this.getLatestVersionFromDockerHub(browserInstance);
                }
                catch (Exception e) {
                    this.log.warn("There was an error in browser initilization from Docker hub ... using properties values instead");
                    latestVersion = this.getLatestVersionFromProperties(browserInstance);
                }
            }
        } else {
            latestVersion = this.getLatestVersionFromProperties(browserInstance);
        }
        return latestVersion;
    }

    public String getVersionFromLabel(BrowserInstance browserInstance, String label) {
        int beforeVersion = Integer.parseInt(label.replace("latest-", ""));
        String latestVersion = this.getLatestVersion(browserInstance);
        String previousVersion = this.getPreviousVersion(beforeVersion, latestVersion);
        this.log.debug("Version {} for {} (latest version {}) = {}", new Object[]{label, browserInstance, latestVersion, previousVersion});
        return previousVersion;
    }

    private String getPreviousVersion(int beforeVersion, String latestVersion) {
        int jLatestVersion;
        int iLatestVersion = latestVersion.indexOf(95) + 1;
        int latestVersionInt = Integer.parseInt(latestVersion.substring(iLatestVersion, jLatestVersion = latestVersion.indexOf(46)));
        if (beforeVersion > latestVersionInt) {
            return null;
        }
        return String.valueOf(latestVersionInt - beforeVersion) + VERSION_SUFFIX;
    }

    public String getLatestVersionFromDockerHub(BrowserInstance browserInstance) throws IOException {
        VersionComparator versionComparator = new VersionComparator();
        List browserList = null;
        String latestVersion = null;
        DockerHubService dockerHubService = new DockerHubService(this.getConfig());
        List<DockerHubTags.DockerHubTag> dockerHubTags = dockerHubService.listTags();
        switch (browserInstance.getBrowserType()) {
            case FIREFOX: {
                String firefoxPreffix = "firefox_";
                browserList = dockerHubTags.stream().filter(p -> p.getName().startsWith("firefox_")).map(p -> p.getName().replace("firefox_", "")).sorted(versionComparator::compare).collect(Collectors.toList());
                latestVersion = (String)browserList.get(browserList.size() - 1);
                break;
            }
            case OPERA: {
                String operaPreffix = "opera_";
                browserList = dockerHubTags.stream().filter(p -> p.getName().startsWith("opera_")).map(p -> p.getName().replace("opera_", "")).sorted(versionComparator::compare).skip(1L).collect(Collectors.toList());
                latestVersion = (String)browserList.get(browserList.size() - 1);
                break;
            }
            default: {
                String chromePreffix = "chrome_";
                browserList = dockerHubTags.stream().filter(p -> p.getName().startsWith("chrome_")).map(p -> p.getName().replace("chrome_", "")).sorted(versionComparator::compare).collect(Collectors.toList());
                latestVersion = (String)browserList.get(browserList.size() - 1);
            }
        }
        if (this.getConfig().isUsePreferences()) {
            this.preferences.putValueInPreferencesIfEmpty(browserInstance.getBrowserName(), latestVersion);
        }
        return latestVersion;
    }

    private String getLatestVersionFromProperties(BrowserInstance browserInstance) {
        String latestVersion = null;
        switch (browserInstance.getBrowserType()) {
            case FIREFOX: {
                latestVersion = this.getConfig().getFirefoxLatestVersion();
                break;
            }
            case OPERA: {
                latestVersion = this.getConfig().getOperaLatestVersion();
                break;
            }
            default: {
                latestVersion = this.getConfig().getChromeLatestVersion();
            }
        }
        return latestVersion;
    }

    public BrowserConfig getBrowserConfig(BrowserType browser) {
        switch (browser) {
            case FIREFOX: {
                return this.firefox;
            }
            case OPERA: {
                return this.operablink;
            }
        }
        return this.chrome;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getVersion() {
        return this.version;
    }

    public class Tmpfs {
        @SerializedName(value="/tmp")
        String tmp;

        public Tmpfs() {
            this.tmp = "size=" + DockerBrowserConfig.this.getConfig().getSelenoidTmpfsSize();
        }
    }

    public class Browser {
        String image;
        String port;
        String path;
        Tmpfs tmpfs;
        List<String> env;

        public Browser(String image, String path, List<String> envs) {
            this.port = DockerBrowserConfig.this.getConfig().getSelenoidPort();
            this.tmpfs = new Tmpfs();
            this.env = new ArrayList<String>();
            this.image = image;
            this.path = path;
            this.env = envs;
        }

        public String getImage() {
            return this.image;
        }
    }

    public class BrowserConfig {
        @SerializedName(value="default")
        String defaultBrowser;
        Map<String, Browser> versions;

        public BrowserConfig(String defaultBrowser) {
            this.defaultBrowser = defaultBrowser;
            this.versions = new HashMap<String, Browser>();
        }

        public void addBrowser(String version, Browser browser) {
            this.versions.put(version, browser);
        }

        public String getDefaultBrowser() {
            return this.defaultBrowser;
        }

        public Map<String, Browser> getVersions() {
            return this.versions;
        }
    }
}

