/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurefireReports {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private SurefireReports() {
        throw new IllegalStateException("Utility class");
    }

    public static String getOutputFolder(ExtensionContext context, String outputFolder) {
        Optional testMethod = context.getTestMethod();
        Optional testInstance = context.getTestClass();
        if (testMethod.isPresent() && testInstance.isPresent()) {
            if (outputFolder.equalsIgnoreCase("surefire-reports")) {
                outputFolder = SurefireReports.getSurefireOutputFolder((Method)testMethod.get(), (Class)testInstance.get());
            } else if (outputFolder.isEmpty()) {
                outputFolder = ".";
            }
        }
        log.trace("Output folder {}", (Object)outputFolder);
        File outputFolderFile = new File(outputFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        return outputFolder;
    }

    private static String getSurefireOutputFolder(Method testMethod, Class<?> testInstance) {
        Annotation[] annotations = testMethod.getAnnotations();
        StringBuilder stringBuilder = new StringBuilder("./target/surefire-reports/");
        boolean isTestTemplate = Arrays.stream(annotations).map(Annotation::annotationType).anyMatch(a -> a == TestTemplate.class);
        log.trace("Is test template? {}", (Object)isTestTemplate);
        if (isTestTemplate) {
            stringBuilder.append(testMethod.getName());
            stringBuilder.append("(");
            Class<?>[] parameterTypes = testMethod.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(parameterTypes[i].getSimpleName());
            }
            stringBuilder.append(")/");
        } else {
            stringBuilder.append(testInstance.getName());
        }
        return stringBuilder.toString();
    }
}

