/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.PortBinding;
import io.appium.java_client.android.AndroidDriver;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.DockerContainer;
import io.github.bonigarcia.seljup.DockerService;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.SelenoidConfig;
import io.github.bonigarcia.seljup.SurefireReports;
import io.github.bonigarcia.seljup.WebDriverCreator;
import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerDriverHandler {
    static final String ALL_IPV4_ADDRESSES = "0.0.0.0";
    static final String LATEST = "latest";
    static final String BROWSER = "browser";
    static final String CHROME = "chrome";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    DockerService dockerService;
    SelenoidConfig selenoidConfig;
    Map<String, DockerContainer> containerMap;
    File recordingFile;
    String name;
    File hostVideoFolder;
    ExtensionContext context;
    Parameter parameter;
    Optional<Object> testInstance;
    AnnotationsReader annotationsReader;
    String index;
    String androidNoVncUrl;
    List<File> filesInVideoFolder;
    String browserName;
    WebDriverCreator webDriverCreator;
    URL hubUrl;

    public DockerDriverHandler(Config config, BrowserInstance browserInstance, String version, InternalPreferences preferences) {
        this.config = config;
        this.selenoidConfig = new SelenoidConfig(config, browserInstance, version);
        this.dockerService = new DockerService(config, preferences);
        this.containerMap = new LinkedHashMap<String, DockerContainer>();
    }

    public DockerDriverHandler(ExtensionContext context, Parameter parameter, Optional<Object> testInstance, AnnotationsReader annotationsReader, Map<String, DockerContainer> containerMap, DockerService dockerService, Config config, BrowserInstance browserInstance, String version) {
        this.context = context;
        this.parameter = parameter;
        this.testInstance = testInstance;
        this.annotationsReader = annotationsReader;
        this.containerMap = containerMap;
        this.dockerService = dockerService;
        this.config = config;
        this.selenoidConfig = new SelenoidConfig(this.getConfig(), browserInstance, version);
    }

    public WebDriver resolve(DockerBrowser dockerBrowser) {
        BrowserType browserType = dockerBrowser.type();
        BrowserInstance browserInstance = new BrowserInstance(this.config, browserType);
        String version = dockerBrowser.version();
        String deviceName = dockerBrowser.deviceName();
        String url = dockerBrowser.url();
        return this.resolve(browserInstance, version, deviceName, url, true);
    }

    public WebDriver resolve(BrowserInstance browserInstance, String version, String deviceName, String url, boolean createWebDriver) {
        BrowserType browserType = browserInstance.getBrowserType();
        try {
            if (url != null && !url.isEmpty()) {
                this.dockerService.updateDockerClient(url);
            }
            if (this.getConfig().isRecording()) {
                this.hostVideoFolder = new File(SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder()));
            }
            WebDriver webdriver = browserType == BrowserType.ANDROID ? this.getDriverForAndroid(browserInstance, version, deviceName) : this.getDriverForBrowser(browserInstance, version, createWebDriver);
            return webdriver;
        }
        catch (Exception e) {
            String errorMessage = String.format("Exception resolving driver in Docker (%s %s)", new Object[]{browserType, version});
            throw new SeleniumJupiterException(errorMessage, e);
        }
    }

    private WebDriver getDriverForBrowser(BrowserInstance browserInstance, String version, boolean createWebDriver) throws IllegalAccessException, IOException, DockerException, InterruptedException {
        String imageVersion;
        boolean enableVnc = this.getConfig().isVnc();
        DesiredCapabilities capabilities = this.getCapabilities(browserInstance, enableVnc);
        BrowserType browserType = browserInstance.getBrowserType();
        String versionFromLabel = version;
        if (version != null && !version.isEmpty() && !version.equalsIgnoreCase(LATEST)) {
            if (version.startsWith("latest-")) {
                versionFromLabel = this.selenoidConfig.getDockerBrowserConfig().getVersion();
            }
            imageVersion = this.selenoidConfig.getImageVersion(browserType, versionFromLabel);
            capabilities.setCapability("version", imageVersion);
        } else {
            imageVersion = this.selenoidConfig.getDefaultBrowser(browserType);
        }
        String seleniumServerUrl = this.getConfig().getSeleniumServerUrl();
        boolean seleniumServerUrlAvailable = seleniumServerUrl != null && !seleniumServerUrl.isEmpty();
        this.hubUrl = new URL(seleniumServerUrlAvailable ? seleniumServerUrl : this.startDockerBrowser(browserInstance, versionFromLabel));
        if (!createWebDriver) {
            return null;
        }
        if (this.webDriverCreator == null) {
            this.webDriverCreator = new WebDriverCreator(this.getConfig());
        }
        this.log.trace("Creating webdriver for {} {} ({})", new Object[]{browserType, version, this.hubUrl});
        WebDriver webdriver = this.webDriverCreator.createRemoteWebDriver(this.hubUrl, (Capabilities)capabilities);
        SessionId sessionId = ((RemoteWebDriver)webdriver).getSessionId();
        this.updateName(browserType, imageVersion, webdriver);
        if (enableVnc && !seleniumServerUrlAvailable) {
            String selenoidHost = this.hubUrl.getHost();
            int selenoidPort = this.hubUrl.getPort();
            String novncUrl = this.getNoVncUrl(selenoidHost, selenoidPort, sessionId.toString(), this.getConfig().getSelenoidVncPassword());
            this.logSessionId(sessionId);
            this.logNoVncUrl(novncUrl);
            String vncExport = this.getConfig().getVncExport();
            this.log.trace("Exporting VNC URL as Java property {}", (Object)vncExport);
            System.setProperty(vncExport, novncUrl);
            if (this.getConfig().isVncRedirectHtmlPage()) {
                String outputFolder = SurefireReports.getOutputFolder(this.context, this.getConfig().getOutputFolder());
                String vncHtmlPage = String.format("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0; url=%s\">\n</head>\n<body>\n</body>\n</html>", novncUrl);
                String htmlPageName = this.name + ".html";
                this.log.debug("Redirecting VNC URL to HTML page at {}/{}", (Object)outputFolder, (Object)htmlPageName);
                Files.write(Paths.get(outputFolder, htmlPageName), vncHtmlPage.getBytes(), new OpenOption[0]);
            }
        }
        if (this.getConfig().isRecording()) {
            this.recordingFile = new File(this.hostVideoFolder, sessionId + ".mp4");
        }
        return webdriver;
    }

    private void logSessionId(SessionId sessionId) {
        this.log.info("Session id {}", (Object)sessionId);
    }

    private void logNoVncUrl(String novncUrl) {
        this.log.info("VNC URL (copy and paste in a browser navigation bar to interact with remote session)");
        this.log.info("{}", (Object)novncUrl);
    }

    private WebDriver getDriverForAndroid(BrowserInstance browserInstance, String version, String deviceName) throws DockerException, InterruptedException, IOException, IllegalAccessException {
        if (this.getConfig().isRecording()) {
            this.filesInVideoFolder = Arrays.asList(this.hostVideoFolder.listFiles());
        }
        if (version == null || version.isEmpty()) {
            version = this.getConfig().getAndroidDefaultVersion();
        }
        String deviceNameCapability = deviceName != null && !deviceName.isEmpty() ? deviceName : this.getConfig().getAndroidDeviceName();
        String appiumUrl = this.startAndroidBrowser(version, deviceNameCapability);
        DesiredCapabilities capabilities = this.getCapabilitiesForAndroid(browserInstance, deviceNameCapability);
        this.log.info("Appium URL in Android device: {}", (Object)appiumUrl);
        this.log.info("Android device name: {} -- Browser: {}", (Object)deviceNameCapability, (Object)this.browserName);
        this.log.info("Waiting for Android device ... this might take long, please wait (retries each 5 seconds)");
        AndroidDriver androidDriver = null;
        int androidDeviceTimeoutSec = this.getConfig().getAndroidDeviceTimeoutSec();
        long endTimeMillis = System.currentTimeMillis() + (long)(androidDeviceTimeoutSec * 1000);
        do {
            try {
                androidDriver = new AndroidDriver(new URL(appiumUrl), (Capabilities)capabilities);
            }
            catch (Exception e) {
                if (System.currentTimeMillis() > endTimeMillis) {
                    throw new SeleniumJupiterException("Timeout (" + androidDeviceTimeoutSec + " seconds) waiting for Android device in Docker");
                }
                String errorMessage = this.getErrorMessage(e);
                this.log.debug("Android device not ready: {}", (Object)errorMessage);
                if (errorMessage.contains("Could not find package")) {
                    throw new SeleniumJupiterException(errorMessage);
                }
                Thread.sleep(5000L);
            }
        } while (androidDriver == null);
        this.log.info("Android device ready {}", (Object)androidDriver);
        this.updateName(browserInstance.getBrowserType(), version, (WebDriver)androidDriver);
        if (this.getConfig().isVnc()) {
            this.logSessionId(androidDriver.getSessionId());
            this.logNoVncUrl(this.androidNoVncUrl);
        }
        return androidDriver;
    }

    private String getErrorMessage(Exception e) {
        String errorMessage = ExceptionUtils.getRootCause((Throwable)e).getMessage();
        int i = errorMessage.indexOf(10);
        if (i != -1) {
            errorMessage = errorMessage.substring(0, i);
        }
        return errorMessage;
    }

    private void updateName(BrowserType browser, String imageVersion, WebDriver webdriver) {
        if (this.parameter != null) {
            String parameterName = this.parameter.getName();
            this.name = parameterName + "_" + (Object)((Object)browser) + "_" + imageVersion + "_" + ((RemoteWebDriver)webdriver).getSessionId();
            Optional testMethod = this.context.getTestMethod();
            if (testMethod.isPresent()) {
                this.name = ((Method)testMethod.get()).getName() + "_" + this.name;
            }
            if (this.index != null) {
                this.name = this.name + this.index;
            }
        } else {
            this.name = browser.name().toLowerCase();
        }
    }

    private DesiredCapabilities getCapabilities(BrowserInstance browserInstance, boolean enableVnc) throws IllegalAccessException, IOException {
        DesiredCapabilities capabilities = browserInstance.getCapabilities();
        if (enableVnc) {
            capabilities.setCapability("enableVNC", true);
            capabilities.setCapability("screenResolution", this.getConfig().getVncScreenResolution());
        }
        if (this.getConfig().isRecording()) {
            capabilities.setCapability("enableVideo", true);
            capabilities.setCapability("videoScreenSize", this.getConfig().getRecordingVideoScreenSize());
            capabilities.setCapability("videoFrameRate", (Object)this.getConfig().getRecordingVideoFrameRate());
        }
        Optional<DesiredCapabilities> optionalCapabilities = this.annotationsReader != null ? this.annotationsReader.getCapabilities(this.parameter, this.testInstance) : Optional.of(new DesiredCapabilities());
        MutableCapabilities options = browserInstance.getDriverHandler().getOptions(this.parameter, this.testInstance);
        if (browserInstance.getBrowserType() == BrowserType.OPERA) {
            ((OperaOptions)options).setBinary("/usr/bin/opera");
        }
        if (optionalCapabilities.isPresent()) {
            options.merge((Capabilities)optionalCapabilities.get());
        }
        capabilities.setCapability(browserInstance.getOptionsKey(), (Object)options);
        this.log.trace("Using {}", (Object)capabilities);
        return capabilities;
    }

    private DesiredCapabilities getCapabilitiesForAndroid(BrowserInstance browserInstance, String deviceNameCapability) throws IllegalAccessException, IOException {
        DesiredCapabilities capabilities = browserInstance.getCapabilities();
        capabilities.setCapability("browserName", this.browserName);
        capabilities.setCapability("deviceName", deviceNameCapability);
        Optional<DesiredCapabilities> optionalCapabilities = this.annotationsReader != null ? this.annotationsReader.getCapabilities(this.parameter, this.testInstance) : Optional.of(new DesiredCapabilities());
        MutableCapabilities options = browserInstance.getDriverHandler().getOptions(this.parameter, this.testInstance);
        if (optionalCapabilities.isPresent()) {
            options.merge((Capabilities)optionalCapabilities.get());
        }
        capabilities.setCapability("goog:chromeOptions", (Object)options);
        this.log.trace("Using {}", (Object)capabilities);
        return capabilities;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.getConfig().isRecording()) {
                this.waitForRecording();
            }
            String vncExport = this.getConfig().getVncExport();
            if (this.getConfig().isVnc() && System.getProperty(vncExport) != null) {
                this.log.trace("Clearing Java property {}", (Object)vncExport);
                System.clearProperty(vncExport);
            }
        }
        catch (Exception e) {
            this.log.warn("Exception waiting for recording {}", (Object)e.getMessage());
        }
        finally {
            if (this.containerMap != null && !this.containerMap.isEmpty() && this.dockerService != null) {
                int numContainers = this.containerMap.size();
                this.log.trace("There are {} container(s): {}", (Object)numContainers, this.containerMap);
                if (numContainers > 0) {
                    ExecutorService executorService = Executors.newFixedThreadPool(numContainers);
                    CountDownLatch latch = new CountDownLatch(numContainers);
                    for (Map.Entry<String, DockerContainer> entry : this.containerMap.entrySet()) {
                        executorService.submit(() -> {
                            this.dockerService.stopAndRemoveContainer(((DockerContainer)entry.getValue()).getContainerId(), (String)entry.getKey());
                            latch.countDown();
                        });
                    }
                    this.containerMap.clear();
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    executorService.shutdown();
                }
            }
        }
    }

    public void close() {
        this.dockerService.close();
    }

    public String startAndroidBrowser(String version, String deviceName) throws DockerException, InterruptedException {
        String browserVersion;
        String apiLevel;
        String androidImage;
        if (!SystemUtils.IS_OS_LINUX) {
            throw new SeleniumJupiterException("Android devices are only supported in Linux hosts");
        }
        switch (version) {
            case "5.0.1": 
            case "latest-7": {
                androidImage = this.getConfig().getAndroidImage501();
                apiLevel = "21";
                this.browserName = BROWSER;
                browserVersion = "37.0";
                break;
            }
            case "5.1.1": 
            case "latest-6": {
                androidImage = this.getConfig().getAndroidImage511();
                apiLevel = "22";
                this.browserName = BROWSER;
                browserVersion = "39.0";
                break;
            }
            case "6.0": 
            case "latest-5": {
                androidImage = this.getConfig().getAndroidImage60();
                apiLevel = "23";
                this.browserName = BROWSER;
                browserVersion = "44.0";
                break;
            }
            case "7.0": 
            case "latest-4": {
                androidImage = this.getConfig().getAndroidImage701();
                apiLevel = "24";
                this.browserName = CHROME;
                browserVersion = "51.0";
                break;
            }
            case "7.1.1": 
            case "latest-3": {
                androidImage = this.getConfig().getAndroidImage711();
                apiLevel = "25";
                this.browserName = CHROME;
                browserVersion = "55.0";
                break;
            }
            case "8.0": 
            case "latest-2": {
                androidImage = this.getConfig().getAndroidImage80();
                apiLevel = "26";
                this.browserName = CHROME;
                browserVersion = "58.0";
                break;
            }
            case "8.1": 
            case "latest-1": {
                androidImage = this.getConfig().getAndroidImage81();
                apiLevel = "27";
                this.browserName = CHROME;
                browserVersion = "61.0";
                break;
            }
            case "9.0": 
            case "latest": {
                androidImage = this.getConfig().getAndroidImage90();
                apiLevel = "28";
                this.browserName = CHROME;
                browserVersion = "66.0";
                break;
            }
            default: {
                throw new SeleniumJupiterException("Version " + version + " not valid for Android devices");
            }
        }
        this.log.info("Starting {} {} in Android {} (API level {})", new Object[]{this.browserName, browserVersion, version, apiLevel});
        this.dockerService.pullImage(androidImage);
        DockerContainer androidContainer = this.startAndroidContainer(androidImage, deviceName);
        return androidContainer.getContainerUrl();
    }

    public String startDockerBrowser(BrowserInstance browserInstance, String version) throws DockerException, InterruptedException {
        String browserImage;
        BrowserType browserType = browserInstance.getBrowserType();
        if (version == null || version.isEmpty() || version.equalsIgnoreCase(LATEST)) {
            this.log.info("Using {} version {} (latest)", (Object)browserType, (Object)this.selenoidConfig.getDefaultBrowser(browserType));
            browserImage = this.selenoidConfig.getLatestImage(browserInstance);
        } else {
            this.log.info("Using {} version {}", (Object)browserInstance, (Object)version);
            browserImage = this.selenoidConfig.getImageFromVersion(browserType, version);
        }
        this.dockerService.pullImage(browserImage);
        DockerContainer selenoidContainer = this.startSelenoidContainer();
        return selenoidContainer.getContainerUrl();
    }

    public DockerContainer startSelenoidContainer() throws DockerException, InterruptedException {
        DockerContainer selenoidContainer;
        String selenoidImage = this.getConfig().getSelenoidImage();
        boolean recording = this.getConfig().isRecording();
        if (this.containerMap.containsKey(selenoidImage)) {
            this.log.trace("Selenoid container already available");
            selenoidContainer = this.containerMap.get(selenoidImage);
        } else {
            String defaultSelenoidPort;
            this.dockerService.pullImage(selenoidImage);
            String recordingImage = this.getConfig().getRecordingImage();
            if (recording) {
                this.dockerService.pullImage(recordingImage);
            }
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String internalSelenoidPort = defaultSelenoidPort = this.getConfig().getSelenoidPort();
            portBindings.put(internalSelenoidPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String defaultSocket = this.dockerService.getDockerDefaultSocket();
            ArrayList<String> binds = new ArrayList<String>();
            binds.add(defaultSocket + ":" + defaultSocket);
            if (recording) {
                binds.add(this.getDockerPath(this.hostVideoFolder) + ":/opt/selenoid/video");
            }
            List<String> entryPoint = Arrays.asList("");
            String internalBrowserPort = this.getConfig().getSelenoidPort();
            String browsersJson = this.selenoidConfig.getBrowsersJsonAsString();
            String browserTimeout = this.getConfig().getBrowserSessionTimeoutDuration();
            String network = this.getConfig().getDockerNetwork();
            List<String> cmd = Arrays.asList("sh", "-c", "mkdir -p /etc/selenoid/; echo '" + browsersJson + "' > /etc/selenoid/browsers.json; /usr/bin/selenoid -listen :" + internalBrowserPort + " -conf /etc/selenoid/browsers.json -video-output-dir /opt/selenoid/video/ -timeout " + browserTimeout + " -container-network " + network + " -limit " + this.getDockerBrowserCount());
            List<String> envs = this.selenoidConfig.getDockerEnvs();
            if (recording) {
                envs.add("OVERRIDE_VIDEO_OUTPUT_DIR=" + this.getDockerPath(this.hostVideoFolder));
            }
            DockerContainer.DockerBuilder dockerBuilder = DockerContainer.dockerBuilder(selenoidImage).portBindings(portBindings).binds(binds).cmd(cmd).entryPoint(entryPoint).envs(envs).network(network);
            selenoidContainer = dockerBuilder.build();
            this.containerMap.put(selenoidImage, selenoidContainer);
            String containerId = this.dockerService.startContainer(selenoidContainer);
            selenoidContainer.setContainerId(containerId);
            String selenoidHost = this.dockerService.getHost(containerId, network);
            String selenoidPort = this.dockerService.getBindPort(containerId, internalSelenoidPort + "/tcp");
            String selenoidUrl = String.format("http://%s:%s/wd/hub", selenoidHost, selenoidPort);
            selenoidContainer.setContainerUrl(selenoidUrl);
            this.log.trace("Selenium server URL {}", (Object)selenoidUrl);
        }
        return selenoidContainer;
    }

    public DockerContainer startAndroidContainer(String androidImage, String deviceName) throws DockerException, InterruptedException {
        DockerContainer androidContainer;
        if (this.containerMap.containsKey(androidImage)) {
            this.log.trace("Android container already available");
            androidContainer = this.containerMap.get(androidImage);
        } else {
            this.dockerService.pullImage(androidImage);
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String internalAppiumPort = this.getConfig().getAndroidAppiumPort();
            portBindings.put(internalAppiumPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String internalNoVncPort = this.getConfig().getAndroidNoVncPort();
            portBindings.put(internalNoVncPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            boolean recording = this.getConfig().isRecording();
            ArrayList<String> binds = new ArrayList<String>();
            if (recording) {
                binds.add(this.getDockerPath(this.hostVideoFolder) + ":/tmp/video");
            }
            String network = this.getConfig().getDockerNetwork();
            ArrayList<String> envs = new ArrayList<String>();
            envs.add("DEVICE=" + deviceName);
            envs.add("APPIUM=True");
            List<String> proxyEnvVars = Arrays.asList("HTTP_PROXY", "HTTPS_PROXY", "NO_PROXY", "http_proxy", "https_proxy", "no_proxy");
            proxyEnvVars.stream().filter(envName -> StringUtils.isNotBlank((CharSequence)System.getenv(envName))).forEach(envName -> envs.add(envName + "=" + System.getenv(envName)));
            if (recording) {
                envs.add("AUTO_RECORD=True");
            }
            DockerContainer.DockerBuilder dockerBuilder = DockerContainer.dockerBuilder(androidImage).portBindings(portBindings).binds(binds).envs(envs).network(network).privileged();
            androidContainer = dockerBuilder.build();
            String containerId = this.dockerService.startContainer(androidContainer);
            String androidHost = this.dockerService.getHost(containerId, network);
            String androidPort = this.dockerService.getBindPort(containerId, internalAppiumPort + "/tcp");
            String appiumUrl = String.format("http://%s:%s/wd/hub", androidHost, androidPort);
            androidContainer.setContainerId(containerId);
            androidContainer.setContainerUrl(appiumUrl);
            String androidNoVncPort = this.dockerService.getBindPort(containerId, internalNoVncPort + "/tcp");
            this.androidNoVncUrl = String.format("http://%s:%s/", androidHost, androidNoVncPort);
            this.containerMap.put(androidImage, androidContainer);
        }
        return androidContainer;
    }

    private int getDockerBrowserCount() {
        int count = 0;
        if (this.context != null) {
            Optional testClass = this.context.getTestClass();
            if (testClass.isPresent()) {
                Method[] declaredMethods;
                Constructor<?>[] declaredConstructors;
                for (Constructor<?> constructor : declaredConstructors = ((Class)testClass.get()).getDeclaredConstructors()) {
                    Parameter[] parameters = constructor.getParameters();
                    count += this.getDockerBrowsersInParams(parameters);
                }
                for (Method method : declaredMethods = ((Class)testClass.get()).getDeclaredMethods()) {
                    Parameter[] parameters = method.getParameters();
                    count += this.getDockerBrowsersInParams(parameters);
                }
            }
        } else {
            count = 1;
        }
        this.log.trace("Number of required Docker browser(s): {}", (Object)count);
        return count;
    }

    private int getDockerBrowsersInParams(Parameter[] parameters) {
        int count = 0;
        for (Parameter param : parameters) {
            DockerBrowser dockerBrowser;
            Class<List> type = param.getType();
            if (WebDriver.class.isAssignableFrom(type)) {
                ++count;
                continue;
            }
            if (!type.isAssignableFrom(List.class) || (dockerBrowser = param.getAnnotation(DockerBrowser.class)) == null) continue;
            count += dockerBrowser.size();
        }
        return count;
    }

    private String getNoVncUrl(String selenoidHost, int selenoidPort, String sessionId, String novncPassword) throws DockerException, InterruptedException {
        DockerContainer novncContainer = this.startNoVncContainer();
        String novncUrl = novncContainer.getContainerUrl();
        return String.format(novncUrl + "vnc.html?host=%s&port=%d&path=vnc/%s&resize=scale&autoconnect=true&password=%s", selenoidHost, selenoidPort, sessionId, novncPassword);
    }

    public DockerContainer startNoVncContainer() throws DockerException, InterruptedException {
        DockerContainer novncContainer;
        String novncImage = this.getConfig().getNovncImage();
        if (this.containerMap.containsKey(novncImage)) {
            this.log.debug("noVNC container already available");
            novncContainer = this.containerMap.get(novncImage);
        } else {
            this.dockerService.pullImage(novncImage);
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            String defaultNovncPort = this.getConfig().getNovncPort();
            portBindings.put(defaultNovncPort, Arrays.asList(PortBinding.randomPort((String)ALL_IPV4_ADDRESSES)));
            String network = this.getConfig().getDockerNetwork();
            novncContainer = DockerContainer.dockerBuilder(novncImage).portBindings(portBindings).network(network).build();
            String containerId = this.dockerService.startContainer(novncContainer);
            String novncHost = this.dockerService.getHost(containerId, network);
            String novncPort = this.dockerService.getBindPort(containerId, defaultNovncPort + "/tcp");
            String novncUrl = String.format("http://%s:%s/", novncHost, novncPort);
            novncContainer.setContainerId(containerId);
            novncContainer.setContainerUrl(novncUrl);
            this.containerMap.put(novncImage, novncContainer);
        }
        return novncContainer;
    }

    private String getDockerPath(File file) {
        String fileString = file.getAbsolutePath();
        if (fileString.contains(":")) {
            fileString = Character.toLowerCase(fileString.charAt(0)) + fileString.substring(1);
            fileString = fileString.replaceAll("\\\\", "/");
            fileString = fileString.replaceAll(":", "");
            fileString = "/" + fileString;
        }
        this.log.trace("The path of file {} in Docker format is {}", (Object)file, (Object)fileString);
        return fileString;
    }

    private void waitForRecording() throws IOException {
        List<File> newFilesInVideoFolder;
        Iterator iterator;
        if (this.filesInVideoFolder != null && (iterator = CollectionUtils.disjunction(this.filesInVideoFolder, newFilesInVideoFolder = Arrays.asList(this.hostVideoFolder.listFiles())).iterator()).hasNext()) {
            String filename = iterator.next().toString();
            this.recordingFile = new File(filename);
        }
        if (this.recordingFile != null) {
            int dockerWaitTimeoutSec = this.dockerService.getDockerWaitTimeoutSec();
            int dockerPollTimeMs = this.dockerService.getDockerPollTimeMs();
            long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(dockerWaitTimeoutSec);
            this.log.debug("Waiting for recording {} to be available", (Object)this.recordingFile);
            while (!this.recordingFile.exists()) {
                if (System.currentTimeMillis() > timeoutMs) {
                    this.log.warn("Timeout of {} seconds waiting for file {}", (Object)dockerWaitTimeoutSec, (Object)this.recordingFile);
                    break;
                }
                this.log.trace("Recording {} not present ... waiting {} ms", (Object)this.recordingFile, (Object)dockerPollTimeMs);
                try {
                    Thread.sleep(dockerPollTimeMs);
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted Exception while waiting for container", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            this.log.trace("Renaming {} to {}.mp4", (Object)this.recordingFile, (Object)this.name);
            Files.move(this.recordingFile.toPath(), this.recordingFile.toPath().resolveSibling(this.name + ".mp4"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public Map<String, DockerContainer> getContainerMap() {
        return this.containerMap;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Config getConfig() {
        return this.config;
    }

    public URL getHubUrl() {
        return this.hubUrl;
    }
}

