/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.DockerContainer;
import io.github.bonigarcia.seljup.DockerService;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverHandler {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    AnnotationsReader annotationsReader;
    Parameter parameter;
    ExtensionContext context;
    Map<String, DockerContainer> containerMap;
    DockerService dockerService;
    Object object;

    public abstract void resolve();

    public DriverHandler(Config config) {
        this.config = config;
        this.annotationsReader = new AnnotationsReader(this.getConfig());
    }

    public DriverHandler(Parameter parameter, ExtensionContext context, Config config) {
        this(config);
        this.parameter = parameter;
        this.context = context;
    }

    public Object getObject() {
        return this.object;
    }

    public String getName() {
        String name = "";
        Optional testMethod = this.context.getTestMethod();
        if (testMethod.isPresent()) {
            name = ((Method)testMethod.get()).getName();
        }
        name = name + "_" + this.parameter.getName() + "_" + this.object.getClass().getSimpleName();
        if (RemoteWebDriver.class.isAssignableFrom(this.object.getClass())) {
            name = name + "_" + ((RemoteWebDriver)this.object).getSessionId();
        }
        return name;
    }

    public boolean throwExceptionWhenNoDriver() {
        return this.getConfig().isExceptionWhenNoDriver();
    }

    void handleException(Exception e) {
        if (this.throwExceptionWhenNoDriver()) {
            log.trace("Internal error in selenium-jupiter", (Throwable)e);
            throw new SeleniumJupiterException(e);
        }
        log.warn("Error creating WebDriver object", (Throwable)e);
    }

    File getExtension(String fileName) {
        File file = new File(fileName);
        try {
            InputStream inputStream;
            if (!file.exists() && (inputStream = this.getClass().getResourceAsStream("/" + file)) != null) {
                file = File.createTempFile("tmp-", fileName);
                file.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            }
        }
        catch (Exception e) {
            log.warn("There was a problem handling extension", (Throwable)e);
        }
        return file;
    }

    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        throw new IllegalAccessException("Not implemented");
    }

    public void cleanup() {
    }

    public void setContainerMap(Map<String, DockerContainer> containerMap) {
        this.containerMap = containerMap;
    }

    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    public Config getConfig() {
        return this.config;
    }
}

