/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.CloudType;
import java.util.List;
import java.util.stream.Stream;

public class BrowsersTemplate {
    static final String IN_DOCKER = "-in-docker";
    List<List<Browser>> browsers;

    public Stream<List<Browser>> getStream() {
        return this.browsers.stream();
    }

    public static class Browser {
        String type;
        String version;
        String browserName;
        String deviceName;
        String url;
        String cloud;

        public Browser(String type, String version, String browserName, String deviceName, String url, String cloud) {
            this.type = type;
            this.version = version;
            this.browserName = browserName;
            this.deviceName = deviceName;
            this.url = url;
            this.cloud = cloud;
        }

        public Browser(String type, String version) {
            this.type = type;
            this.version = version;
        }

        public Browser(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBrowserName() {
            return this.browserName;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getCloud() {
            return this.cloud;
        }

        public void setCloud(String cloud) {
            this.cloud = cloud;
        }

        public BrowserType toBrowserType() {
            return BrowserType.valueOf(this.getType().replace(BrowsersTemplate.IN_DOCKER, "").toUpperCase());
        }

        public CloudType toCloudType() {
            if (this.getCloud() == null || this.getCloud().isEmpty()) {
                return CloudType.NONE;
            }
            return CloudType.valueOf(this.getCloud().toUpperCase());
        }

        public boolean isDockerBrowser() {
            return this.getType().contains(BrowsersTemplate.IN_DOCKER);
        }

        public String toString() {
            String versionMessage = this.getVersion() != null ? ", version=" + this.getVersion() : "";
            return "Browser [type=" + this.getType() + versionMessage + "]";
        }
    }
}

