/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.SeleniumJupiter;
import io.github.bonigarcia.seljup.config.Config;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalPreferences {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String TTL = "-ttl";
    Preferences prefs = Preferences.userNodeForPackage(SeleniumJupiter.class);
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Config config;

    public InternalPreferences(Config config) {
        this.config = config;
    }

    public String getValueFromPreferences(String key) {
        return this.prefs.get(key, null);
    }

    private long getExpirationTimeFromPreferences(String key) {
        return this.prefs.getLong(this.getExpirationKey(key), 0L);
    }

    public void putValueInPreferencesIfEmpty(String key, String value) {
        if (this.getValueFromPreferences(key) == null) {
            this.prefs.put(key, value);
            long expirationTime = new Date().getTime() + TimeUnit.SECONDS.toMillis(this.config.getTtlSec());
            this.prefs.putLong(this.getExpirationKey(key), expirationTime);
            if (this.log.isDebugEnabled()) {
                this.log.trace("Storing preference {}={} (valid until {})", new Object[]{key, value, this.formatTime(expirationTime)});
            }
        }
    }

    private void clearFromPreferences(String key) {
        this.prefs.remove(key);
        this.prefs.remove(this.getExpirationKey(key));
    }

    public void clear() {
        try {
            this.log.info("Clearing Selenium-Jupiter preferences");
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            this.log.warn("Exception clearing preferences", (Throwable)e);
        }
    }

    private boolean checkValidity(String key, String value, long expirationTime) {
        boolean isValid;
        long now = new Date().getTime();
        boolean bl = isValid = value != null && expirationTime != 0L && expirationTime > now;
        if (!isValid) {
            String expirationDate = this.formatTime(expirationTime);
            this.log.trace("Removing preference {}={} (expired on {})", new Object[]{key, value, expirationDate});
            this.clearFromPreferences(key);
        }
        return isValid;
    }

    private String formatTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private String getExpirationKey(String key) {
        return key + TTL;
    }

    public boolean checkKeyInPreferences(String key) {
        boolean valueInPreferences;
        String valueFromPreferences = this.getValueFromPreferences(key);
        boolean bl = valueInPreferences = valueFromPreferences != null && !valueFromPreferences.isEmpty();
        if (valueInPreferences) {
            long expirationTime = this.getExpirationTimeFromPreferences(key);
            String expirationDate = this.formatTime(expirationTime);
            if (valueInPreferences &= this.checkValidity(key, valueFromPreferences, expirationTime)) {
                this.log.trace("Preference found {}={} (valid until {})", new Object[]{key, valueFromPreferences, expirationDate});
            }
        }
        return valueInPreferences;
    }
}

