/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.config;

import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.wdm.ConfigKey;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ConfigKey<String> properties = new ConfigKey("sel.jup.properties", String.class, (Object)"selenium-jupiter.properties");
    ConfigKey<String> seleniumServerUrl = new ConfigKey("sel.jup.selenium.server.url", String.class);
    ConfigKey<Boolean> vnc = new ConfigKey("sel.jup.vnc", Boolean.class);
    ConfigKey<String> vncScreenResolution = new ConfigKey("sel.jup.vnc.screen.resolution", String.class);
    ConfigKey<Boolean> vncRedirectHtmlPage = new ConfigKey("sel.jup.vnc.create.redirect.html.page", Boolean.class);
    ConfigKey<String> vncExport = new ConfigKey("sel.jup.vnc.export", String.class);
    ConfigKey<Boolean> recording = new ConfigKey("sel.jup.recording", Boolean.class);
    ConfigKey<String> recordingVideoScreenSize = new ConfigKey("sel.jup.recording.video.screen.size", String.class);
    ConfigKey<Integer> recordingVideoFrameRate = new ConfigKey("sel.jup.recording.video.frame.rate", Integer.class);
    ConfigKey<String> recordingImage = new ConfigKey("sel.jup.recording.image", String.class);
    ConfigKey<String> outputFolder = new ConfigKey("sel.jup.output.folder", String.class);
    ConfigKey<String> screenshotAtTheEndOfTests = new ConfigKey("sel.jup.screenshot.at.the.end.of.tests", String.class);
    ConfigKey<String> screenshotFormat = new ConfigKey("sel.jup.screenshot.format", String.class);
    ConfigKey<Boolean> exceptionWhenNoDriver = new ConfigKey("sel.jup.exception.when.no.driver", Boolean.class);
    ConfigKey<String> browserTemplateJsonFile = new ConfigKey("sel.jup.browser.template.json.file", String.class);
    ConfigKey<String> browserTemplateJsonContent = new ConfigKey("sel.jup.browser.template.json.content", String.class);
    ConfigKey<String> defaultBrowser = new ConfigKey("sel.jup.default.browser", String.class);
    ConfigKey<String> defaultVersion = new ConfigKey("sel.jup.default.version", String.class);
    ConfigKey<String> defaultBrowserFallback = new ConfigKey("sel.jup.default.browser.fallback", String.class);
    ConfigKey<String> defaultBrowserFallbackVersion = new ConfigKey("sel.jup.default.browser.fallback.version", String.class);
    ConfigKey<Boolean> browserListFromDockerHub = new ConfigKey("sel.jup.browser.list.from.docker.hub", Boolean.class);
    ConfigKey<String> browserSessionTimeoutDuration = new ConfigKey("sel.jup.browser.session.timeout.duration", String.class);
    ConfigKey<Boolean> browserListInParallel = new ConfigKey("sel.jup.browser.list.in.parallel", Boolean.class);
    ConfigKey<String> selenoidImage = new ConfigKey("sel.jup.selenoid.image", String.class);
    ConfigKey<String> selenoidPort = new ConfigKey("sel.jup.selenoid.port", String.class);
    ConfigKey<String> selenoidVncPassword = new ConfigKey("sel.jup.selenoid.vnc.password", String.class);
    ConfigKey<String> selenoidTmpfsSize = new ConfigKey("sel.jup.selenoid.tmpfs.size", String.class);
    ConfigKey<String> novncImage = new ConfigKey("sel.jup.novnc.image", String.class);
    ConfigKey<String> novncPort = new ConfigKey("sel.jup.novnc.port", String.class);
    ConfigKey<String> chromeImageFormat = new ConfigKey("sel.jup.chrome.image.format", String.class);
    ConfigKey<String> chromeFirstVersion = new ConfigKey("sel.jup.chrome.first.version", String.class);
    ConfigKey<String> chromeLatestVersion = new ConfigKey("sel.jup.chrome.latest.version", String.class);
    ConfigKey<String> chromePath = new ConfigKey("sel.jup.chrome.path", String.class);
    ConfigKey<String> chromeBetaImage = new ConfigKey("sel.jup.chrome.beta.image", String.class);
    ConfigKey<String> chromeBetaPath = new ConfigKey("sel.jup.chrome.beta.path", String.class);
    ConfigKey<String> chromeUnstableImage = new ConfigKey("sel.jup.chrome.unstable.image", String.class);
    ConfigKey<String> chromeUnstablePath = new ConfigKey("sel.jup.chrome.unstable.path", String.class);
    ConfigKey<String> firefoxImageFormat = new ConfigKey("sel.jup.firefox.image.format", String.class);
    ConfigKey<String> firefoxFirstVersion = new ConfigKey("sel.jup.firefox.first.version", String.class);
    ConfigKey<String> firefoxLatestVersion = new ConfigKey("sel.jup.firefox.latest.version", String.class);
    ConfigKey<String> firefoxPath = new ConfigKey("sel.jup.firefox.path", String.class);
    ConfigKey<String> firefoxBetaImage = new ConfigKey("sel.jup.firefox.beta.image", String.class);
    ConfigKey<String> firefoxBetaPath = new ConfigKey("sel.jup.firefox.beta.path", String.class);
    ConfigKey<String> firefoxUnstableImage = new ConfigKey("sel.jup.firefox.unstable.image", String.class);
    ConfigKey<String> firefoxUnstablePath = new ConfigKey("sel.jup.firefox.unstable.path", String.class);
    ConfigKey<String> operaImageFormat = new ConfigKey("sel.jup.opera.image.format", String.class);
    ConfigKey<String> operaFirstVersion = new ConfigKey("sel.jup.opera.first.version", String.class);
    ConfigKey<String> operaLatestVersion = new ConfigKey("sel.jup.opera.latest.version", String.class);
    ConfigKey<String> operaPath = new ConfigKey("sel.jup.opera.path", String.class);
    ConfigKey<Integer> dockerWaitTimeoutSec = new ConfigKey("sel.jup.docker.wait.timeout.sec", Integer.class);
    ConfigKey<Integer> dockerPollTimeMs = new ConfigKey("sel.jup.docker.poll.time.ms", Integer.class);
    ConfigKey<String> dockerDefaultSocket = new ConfigKey("sel.jup.docker.default.socket", String.class);
    ConfigKey<String> dockerHubUrl = new ConfigKey("sel.jup.docker.hub.url", String.class);
    ConfigKey<String> dockerServerUrl = new ConfigKey("sel.jup.docker.server.url", String.class);
    ConfigKey<Integer> dockerStopTimeoutSec = new ConfigKey("sel.jup.docker.stop.timeout.sec", Integer.class);
    ConfigKey<String> dockerApiVersion = new ConfigKey("sel.jup.docker.api.version", String.class);
    ConfigKey<String> dockerNetwork = new ConfigKey("sel.jup.docker.network", String.class);
    ConfigKey<String> dockerTimeZone = new ConfigKey("sel.jup.docker.timezone", String.class);
    ConfigKey<String> dockerLang = new ConfigKey("sel.jup.docker.lang", String.class);
    ConfigKey<String> androidDefaultVersion = new ConfigKey("sel.jup.android.default.version", String.class);
    ConfigKey<String> androidImage501 = new ConfigKey("sel.jup.android.image.5.0.1", String.class);
    ConfigKey<String> androidImage511 = new ConfigKey("sel.jup.android.image.5.1.1", String.class);
    ConfigKey<String> androidImage60 = new ConfigKey("sel.jup.android.image.6.0", String.class);
    ConfigKey<String> androidImage701 = new ConfigKey("sel.jup.android.image.7.0.1", String.class);
    ConfigKey<String> androidImage711 = new ConfigKey("sel.jup.android.image.7.1.1", String.class);
    ConfigKey<String> androidImage80 = new ConfigKey("sel.jup.android.image.8.0", String.class);
    ConfigKey<String> androidImage81 = new ConfigKey("sel.jup.android.image.8.1", String.class);
    ConfigKey<String> androidImage90 = new ConfigKey("sel.jup.android.image.9.0", String.class);
    ConfigKey<String> androidImageGenymotion = new ConfigKey("sel.jup.android.image.genymotion", String.class);
    ConfigKey<String> androidGenymotionUser = new ConfigKey("sel.jup.android.genymotion.user", String.class);
    ConfigKey<String> androidGenymotionPassword = new ConfigKey("sel.jup.android.genymotion.password", String.class);
    ConfigKey<String> androidGenymotionLicense = new ConfigKey("sel.jup.android.genymotion.license", String.class);
    ConfigKey<String> androidGenymotionTemplate = new ConfigKey("sel.jup.android.genymotion.template", String.class);
    ConfigKey<String> androidNoVncPort = new ConfigKey("sel.jup.android.novnc.port", String.class);
    ConfigKey<String> androidAppiumPort = new ConfigKey("sel.jup.android.appium.port", String.class);
    ConfigKey<String> androidDeviceName = new ConfigKey("sel.jup.android.device.name", String.class);
    ConfigKey<Integer> androidDeviceTimeoutSec = new ConfigKey("sel.jup.android.device.timeout.sec", Integer.class);
    ConfigKey<Integer> androidDeviceStartupTimeoutSec = new ConfigKey("sel.jup.android.device.startup.timeout.sec", Integer.class);
    ConfigKey<Integer> androidAppiumPingPeriodSec = new ConfigKey("sel.jup.android.appium.ping.period.sec", Integer.class);
    ConfigKey<Boolean> androidLogging = new ConfigKey("sel.jup.android.logging", Boolean.class);
    ConfigKey<String> androidLogsFolder = new ConfigKey("sel.jup.android.logs.folder", String.class);
    ConfigKey<String> androidScreenWidth = new ConfigKey("sel.jup.android.screen.width", String.class);
    ConfigKey<String> androidScreenHeigth = new ConfigKey("sel.jup.android.screen.heigth", String.class);
    ConfigKey<String> androidScreenDepth = new ConfigKey("sel.jup.android.screen.depth", String.class);
    ConfigKey<Integer> serverPort = new ConfigKey("sel.jup.server.port", Integer.class);
    ConfigKey<String> serverPath = new ConfigKey("sel.jup.server.path", String.class);
    ConfigKey<Integer> remoteWebdriverWaitTimeoutSec = new ConfigKey("sel.jup.remote.webdriver.wait.timeout.sec", Integer.class);
    ConfigKey<Integer> remoteWebdriverPollTimeSec = new ConfigKey("sel.jup.remote.webdriver.poll.time.sec", Integer.class);
    ConfigKey<Integer> ttlSec = new ConfigKey("sel.jup.ttl.sec", Integer.class);
    ConfigKey<Boolean> usePreferences = new ConfigKey("sel.jup.wdm.use.preferences", Boolean.class);

    private <T> T resolve(ConfigKey<T> configKey) {
        String strValue = null;
        String name = configKey.getName();
        Object tValue = configKey.getValue();
        Class type = configKey.getType();
        strValue = System.getenv(name.toUpperCase().replace(".", "_"));
        if (strValue == null) {
            strValue = System.getProperty(name);
        }
        if (strValue == null && tValue != null) {
            return (T)tValue;
        }
        if (strValue == null) {
            strValue = this.getProperty(name);
        }
        return this.parse(type, strValue);
    }

    private <T> T parse(Class<T> type, String strValue) {
        Object output = null;
        if (type.equals(String.class)) {
            output = strValue;
        } else if (type.equals(Integer.class)) {
            output = Integer.valueOf(strValue);
        } else if (type.equals(Boolean.class)) {
            output = Boolean.valueOf(strValue);
        } else {
            throw new SeleniumJupiterException("Type " + type.getTypeName() + " cannot be parsed");
        }
        return (T)output;
    }

    private String getProperty(String key) {
        String value = null;
        Properties props = new Properties();
        try {
            InputStream inputStream = Config.class.getResourceAsStream("/" + this.getProperties());
            props.load(inputStream);
            value = props.getProperty(key);
        }
        catch (Exception e) {
            throw new SeleniumJupiterException(e);
        }
        finally {
            if (value == null) {
                this.log.trace("Property key {} not found, using default value", (Object)key);
                value = "";
            }
        }
        return value;
    }

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != ConfigKey.class) continue;
            try {
                ((ConfigKey)field.get(this)).reset();
            }
            catch (Exception e) {
                this.log.warn("Exception reseting {}", (Object)field);
            }
        }
    }

    public String getProperties() {
        return this.resolve(this.properties);
    }

    public void setProperties(boolean properties) {
        this.properties.setValue((Object)properties);
    }

    public String getSeleniumServerUrl() {
        return this.resolve(this.seleniumServerUrl);
    }

    public void setSeleniumServerUrl(String value) {
        this.seleniumServerUrl.setValue((Object)value);
    }

    public boolean isVnc() {
        return this.resolve(this.vnc);
    }

    public void setVnc(boolean value) {
        this.vnc.setValue((Object)value);
    }

    public String getVncScreenResolution() {
        return this.resolve(this.vncScreenResolution);
    }

    public void setVncScreenResolution(String value) {
        this.vncScreenResolution.setValue((Object)value);
    }

    public boolean isVncRedirectHtmlPage() {
        return this.resolve(this.vncRedirectHtmlPage);
    }

    public void setVncRedirectHtmlPage(boolean value) {
        this.vncRedirectHtmlPage.setValue((Object)value);
    }

    public String getVncExport() {
        return this.resolve(this.vncExport);
    }

    public void setVncExport(String value) {
        this.vncExport.setValue((Object)value);
    }

    public boolean isRecording() {
        return this.resolve(this.recording);
    }

    public void setRecording(boolean value) {
        this.recording.setValue((Object)value);
    }

    public String getRecordingVideoScreenSize() {
        return this.resolve(this.recordingVideoScreenSize);
    }

    public void setRecordingVideoScreenSize(String value) {
        this.recordingVideoScreenSize.setValue((Object)value);
    }

    public int getRecordingVideoFrameRate() {
        return this.resolve(this.recordingVideoFrameRate);
    }

    public void setRecordingVideoFrameRate(int value) {
        this.recordingVideoFrameRate.setValue((Object)value);
    }

    public String getRecordingImage() {
        return this.resolve(this.recordingImage);
    }

    public void setRecordingImage(String value) {
        this.recordingImage.setValue((Object)value);
    }

    public String getOutputFolder() {
        return this.resolve(this.outputFolder);
    }

    public void setOutputFolder(String value) {
        this.outputFolder.setValue((Object)value);
    }

    public String getScreenshotAtTheEndOfTests() {
        return this.resolve(this.screenshotAtTheEndOfTests);
    }

    public void setScreenshotAtTheEndOfTests(String value) {
        this.screenshotAtTheEndOfTests.setValue((Object)value);
    }

    public String getScreenshotFormat() {
        return this.resolve(this.screenshotFormat);
    }

    public void setScreenshotFormat(String value) {
        this.screenshotFormat.setValue((Object)value);
    }

    public boolean isExceptionWhenNoDriver() {
        return this.resolve(this.exceptionWhenNoDriver);
    }

    public void setExceptionWhenNoDriver(boolean value) {
        this.exceptionWhenNoDriver.setValue((Object)value);
    }

    public String getBrowserTemplateJsonFile() {
        return this.resolve(this.browserTemplateJsonFile);
    }

    public void setBrowserTemplateJsonFile(String value) {
        this.browserTemplateJsonFile.setValue((Object)value);
    }

    public String getBrowserTemplateJsonContent() {
        return this.resolve(this.browserTemplateJsonContent);
    }

    public void setBrowserTemplateJsonContent(String value) {
        this.browserTemplateJsonContent.setValue((Object)value);
    }

    public String getDefaultBrowser() {
        return this.resolve(this.defaultBrowser);
    }

    public void setDefaultBrowser(String value) {
        this.defaultBrowser.setValue((Object)value);
    }

    public String getDefaultVersion() {
        return this.resolve(this.defaultVersion);
    }

    public void setDefaultVersion(String value) {
        this.defaultVersion.setValue((Object)value);
    }

    public String getDefaultBrowserFallback() {
        return this.resolve(this.defaultBrowserFallback);
    }

    public void setDefaultBrowserFallback(String value) {
        this.defaultBrowserFallback.setValue((Object)value);
    }

    public String getDefaultBrowserFallbackVersion() {
        return this.resolve(this.defaultBrowserFallbackVersion);
    }

    public void setDefaultBrowserFallbackVersion(String value) {
        this.defaultBrowserFallbackVersion.setValue((Object)value);
    }

    public boolean isBrowserListFromDockerHub() {
        return this.resolve(this.browserListFromDockerHub);
    }

    public void setBrowserListFromDockerHub(boolean value) {
        this.browserListFromDockerHub.setValue((Object)value);
    }

    public String getBrowserSessionTimeoutDuration() {
        return this.resolve(this.browserSessionTimeoutDuration);
    }

    public void setBrowserSessionTimeoutDuration(String value) {
        this.browserSessionTimeoutDuration.setValue((Object)value);
    }

    public Boolean isBrowserListInParallel() {
        return this.resolve(this.browserListInParallel);
    }

    public void setBrowserListInParallel(Boolean value) {
        this.browserListInParallel.setValue((Object)value);
    }

    public String getSelenoidImage() {
        return this.resolve(this.selenoidImage);
    }

    public void setSelenoidImage(String value) {
        this.selenoidImage.setValue((Object)value);
    }

    public String getSelenoidPort() {
        return this.resolve(this.selenoidPort);
    }

    public void setSelenoidPort(String value) {
        this.selenoidPort.setValue((Object)value);
    }

    public String getSelenoidVncPassword() {
        return this.resolve(this.selenoidVncPassword);
    }

    public void setSelenoidVncPassword(String value) {
        this.selenoidVncPassword.setValue((Object)value);
    }

    public String getSelenoidTmpfsSize() {
        return this.resolve(this.selenoidTmpfsSize);
    }

    public void setSelenoidTmpfsSize(String value) {
        this.selenoidTmpfsSize.setValue((Object)value);
    }

    public String getNovncImage() {
        return this.resolve(this.novncImage);
    }

    public void setNovncImage(String value) {
        this.novncImage.setValue((Object)value);
    }

    public String getNovncPort() {
        return this.resolve(this.novncPort);
    }

    public void setNovncPort(String value) {
        this.novncPort.setValue((Object)value);
    }

    public String getChromeImageFormat() {
        return this.resolve(this.chromeImageFormat);
    }

    public void setChromeImageFormat(String value) {
        this.chromeImageFormat.setValue((Object)value);
    }

    public String getChromeFirstVersion() {
        return this.resolve(this.chromeFirstVersion);
    }

    public void setChromeFirstVersion(String value) {
        this.chromeFirstVersion.setValue((Object)value);
    }

    public String getChromeLatestVersion() {
        return this.resolve(this.chromeLatestVersion);
    }

    public void setChromeLatestVersion(String value) {
        this.chromeLatestVersion.setValue((Object)value);
    }

    public String getChromePath() {
        return this.resolve(this.chromePath);
    }

    public void setChromePath(String value) {
        this.chromePath.setValue((Object)value);
    }

    public String getChromeBetaImage() {
        return this.resolve(this.chromeBetaImage);
    }

    public void setChromeBetaImage(String value) {
        this.chromeBetaImage.setValue((Object)value);
    }

    public String getChromeBetaPath() {
        return this.resolve(this.chromeBetaPath);
    }

    public void setChromeBetaPath(String value) {
        this.chromeBetaPath.setValue((Object)value);
    }

    public String getChromeUnstableImage() {
        return this.resolve(this.chromeUnstableImage);
    }

    public void setChromeUnstableImage(String value) {
        this.chromeUnstableImage.setValue((Object)value);
    }

    public String getChromeUnstablePath() {
        return this.resolve(this.chromeUnstablePath);
    }

    public void setChromeUnstablePath(String value) {
        this.chromeUnstablePath.setValue((Object)value);
    }

    public String getFirefoxImageFormat() {
        return this.resolve(this.firefoxImageFormat);
    }

    public void setFirefoxImageFormat(String value) {
        this.firefoxImageFormat.setValue((Object)value);
    }

    public String getFirefoxFirstVersion() {
        return this.resolve(this.firefoxFirstVersion);
    }

    public void setFirefoxFirstVersion(String value) {
        this.firefoxFirstVersion.setValue((Object)value);
    }

    public String getFirefoxLatestVersion() {
        return this.resolve(this.firefoxLatestVersion);
    }

    public void setFirefoxLatestVersion(String value) {
        this.firefoxLatestVersion.setValue((Object)value);
    }

    public String getFirefoxPath() {
        return this.resolve(this.firefoxPath);
    }

    public void setFirefoxPath(String value) {
        this.firefoxPath.setValue((Object)value);
    }

    public String getFirefoxBetaImage() {
        return this.resolve(this.firefoxBetaImage);
    }

    public void setFirefoxBetaImage(String value) {
        this.firefoxBetaImage.setValue((Object)value);
    }

    public String getFirefoxBetaPath() {
        return this.resolve(this.firefoxBetaPath);
    }

    public void setFirefoxBetaPath(String value) {
        this.firefoxBetaPath.setValue((Object)value);
    }

    public String getFirefoxUnstableImage() {
        return this.resolve(this.firefoxUnstableImage);
    }

    public void setFirefoxUnstableImage(String value) {
        this.firefoxUnstableImage.setValue((Object)value);
    }

    public String getFirefoxUnstablePath() {
        return this.resolve(this.firefoxUnstablePath);
    }

    public void setFirefoxUnstablePath(String value) {
        this.firefoxUnstablePath.setValue((Object)value);
    }

    public String getOperaImageFormat() {
        return this.resolve(this.operaImageFormat);
    }

    public void setOperaImageFormat(String value) {
        this.operaImageFormat.setValue((Object)value);
    }

    public String getOperaFirstVersion() {
        return this.resolve(this.operaFirstVersion);
    }

    public void setOperaFirstVersion(String value) {
        this.operaFirstVersion.setValue((Object)value);
    }

    public String getOperaLatestVersion() {
        return this.resolve(this.operaLatestVersion);
    }

    public void setOperaLatestVersion(String value) {
        this.operaLatestVersion.setValue((Object)value);
    }

    public String getOperaPath() {
        return this.resolve(this.operaPath);
    }

    public void setOperaPath(String value) {
        this.operaPath.setValue((Object)value);
    }

    public int getDockerWaitTimeoutSec() {
        return this.resolve(this.dockerWaitTimeoutSec);
    }

    public void setDockerWaitTimeoutSec(int dockerWaitTimeoutSec) {
        this.dockerWaitTimeoutSec.setValue((Object)dockerWaitTimeoutSec);
    }

    public int getDockerPollTimeMs() {
        return this.resolve(this.dockerPollTimeMs);
    }

    public void setDockerPollTimeMs(int dockerWaitTimeoutSec) {
        this.dockerPollTimeMs.setValue((Object)dockerWaitTimeoutSec);
    }

    public String getDockerDefaultSocket() {
        return this.resolve(this.dockerDefaultSocket);
    }

    public void setDockerDefaultSocket(String value) {
        this.dockerDefaultSocket.setValue((Object)value);
    }

    public String getDockerHubUrl() {
        return this.resolve(this.dockerHubUrl);
    }

    public void setDockerHubUrl(String dockerHubUrl) {
        this.dockerHubUrl.setValue((Object)dockerHubUrl);
    }

    public String getDockerServerUrl() {
        return this.resolve(this.dockerServerUrl);
    }

    public void setDockerServerUrl(String dockerHubUrl) {
        this.dockerServerUrl.setValue((Object)dockerHubUrl);
    }

    public int getDockerStopTimeoutSec() {
        return this.resolve(this.dockerStopTimeoutSec);
    }

    public void setDockerStopTimeoutSec(int dockerWaitTimeoutSec) {
        this.dockerStopTimeoutSec.setValue((Object)dockerWaitTimeoutSec);
    }

    public String getDockerApiVersion() {
        return this.resolve(this.dockerApiVersion);
    }

    public void setDockerApiVersion(String value) {
        this.dockerApiVersion.setValue((Object)value);
    }

    public String getDockerNetwork() {
        return this.resolve(this.dockerNetwork);
    }

    public void setDockerNetwork(String value) {
        this.dockerNetwork.setValue((Object)value);
    }

    public String getDockerTimeZone() {
        return this.resolve(this.dockerTimeZone);
    }

    public void setDockerTimeZone(String value) {
        this.dockerTimeZone.setValue((Object)value);
    }

    public String getDockerLang() {
        return this.resolve(this.dockerLang);
    }

    public void setDockerLang(String value) {
        this.dockerLang.setValue((Object)value);
    }

    public String getAndroidDefaultVersion() {
        return this.resolve(this.androidDefaultVersion);
    }

    public void setAndroidDefaultVersion(String value) {
        this.androidDefaultVersion.setValue((Object)value);
    }

    public String getAndroidImage501() {
        return this.resolve(this.androidImage501);
    }

    public void setAndroidImage501(String value) {
        this.androidImage501.setValue((Object)value);
    }

    public String getAndroidImage511() {
        return this.resolve(this.androidImage511);
    }

    public void setAndroidImage511(String value) {
        this.androidImage511.setValue((Object)value);
    }

    public String getAndroidImage60() {
        return this.resolve(this.androidImage60);
    }

    public void setAndroidImage60(String value) {
        this.androidImage60.setValue((Object)value);
    }

    public String getAndroidImage701() {
        return this.resolve(this.androidImage701);
    }

    public void setAndroidImage701(String value) {
        this.androidImage701.setValue((Object)value);
    }

    public String getAndroidImage711() {
        return this.resolve(this.androidImage711);
    }

    public void setAndroidImage711(String value) {
        this.androidImage711.setValue((Object)value);
    }

    public String getAndroidImage80() {
        return this.resolve(this.androidImage80);
    }

    public void setAndroidImage80(String value) {
        this.androidImage80.setValue((Object)value);
    }

    public String getAndroidImage81() {
        return this.resolve(this.androidImage81);
    }

    public void setAndroidImage81(String value) {
        this.androidImage81.setValue((Object)value);
    }

    public String getAndroidImage90() {
        return this.resolve(this.androidImage90);
    }

    public void setAndroidImage90(String value) {
        this.androidImage90.setValue((Object)value);
    }

    public String getAndroidImageGenymotion() {
        return this.resolve(this.androidImageGenymotion);
    }

    public void setAndroidImageGenymotion(String value) {
        this.androidImageGenymotion.setValue((Object)value);
    }

    public String getAndroidGenymotionUser() {
        return this.resolve(this.androidGenymotionUser);
    }

    public void setAndroidGenymotionUser(String value) {
        this.androidGenymotionUser.setValue((Object)value);
    }

    public String getAndroidGenymotionPassword() {
        return this.resolve(this.androidGenymotionPassword);
    }

    public void setAndroidGenymotionPassword(String value) {
        this.androidGenymotionPassword.setValue((Object)value);
    }

    public String getAndroidGenymotionLicense() {
        return this.resolve(this.androidGenymotionLicense);
    }

    public void setAndroidGenymotionLicense(String value) {
        this.androidGenymotionLicense.setValue((Object)value);
    }

    public String getAndroidGenymotionTemplate() {
        return this.resolve(this.androidGenymotionTemplate);
    }

    public void setAndroidGenymotionTemplate(String value) {
        this.androidGenymotionTemplate.setValue((Object)value);
    }

    public String getAndroidNoVncPort() {
        return this.resolve(this.androidNoVncPort);
    }

    public void setAndroidNoVncPort(String value) {
        this.androidNoVncPort.setValue((Object)value);
    }

    public String getAndroidAppiumPort() {
        return this.resolve(this.androidAppiumPort);
    }

    public void setAndroidAppiumPort(String value) {
        this.androidAppiumPort.setValue((Object)value);
    }

    public String getAndroidDeviceName() {
        return this.resolve(this.androidDeviceName);
    }

    public void setAndroidDeviceName(String value) {
        this.androidDeviceName.setValue((Object)value);
    }

    public Integer getAndroidDeviceTimeoutSec() {
        return this.resolve(this.androidDeviceTimeoutSec);
    }

    public void setAndroidDeviceTimeoutSec(Integer value) {
        this.androidDeviceTimeoutSec.setValue((Object)value);
    }

    public Integer getAndroidDeviceStartupTimeoutSec() {
        return this.resolve(this.androidDeviceStartupTimeoutSec);
    }

    public void setAndroidDeviceStartupTimeoutSec(Integer value) {
        this.androidDeviceStartupTimeoutSec.setValue((Object)value);
    }

    public Integer getAndroidAppiumPingPeriodSec() {
        return this.resolve(this.androidAppiumPingPeriodSec);
    }

    public void setAndroidAppiumPingPeriodSec(Integer androidAppiumPingPeriodSec) {
        this.androidAppiumPingPeriodSec.setValue((Object)androidAppiumPingPeriodSec);
    }

    public boolean isAndroidLogging() {
        return this.resolve(this.androidLogging);
    }

    public void setAndroidLogging(boolean value) {
        this.androidLogging.setValue((Object)value);
    }

    public String getAndroidLogsFolder() {
        return this.resolve(this.androidLogsFolder);
    }

    public void setAndroidLogsFolder(String androidLogsFolder) {
        this.androidLogsFolder.setValue((Object)androidLogsFolder);
    }

    public String getAndroidScreenWidth() {
        return this.resolve(this.androidScreenWidth);
    }

    public void setAndroidScreenWidth(String value) {
        this.androidScreenWidth.setValue((Object)value);
    }

    public String getAndroidScreenHeigth() {
        return this.resolve(this.androidScreenHeigth);
    }

    public void setAndroidScreenHeigth(String value) {
        this.androidScreenHeigth.setValue((Object)value);
    }

    public String getAndroidScreenDepth() {
        return this.resolve(this.androidScreenDepth);
    }

    public void setAndroidScreenDepth(String value) {
        this.androidScreenDepth.setValue((Object)value);
    }

    public int getServerPort() {
        return this.resolve(this.serverPort);
    }

    public Config setServerPort(int value) {
        this.serverPort.setValue((Object)value);
        return this;
    }

    public String getServerPath() {
        return this.resolve(this.serverPath);
    }

    public Config setServerPath(String value) {
        this.serverPath.setValue((Object)value);
        return this;
    }

    public int getRemoteWebdriverWaitTimeoutSec() {
        return this.resolve(this.remoteWebdriverWaitTimeoutSec);
    }

    public Config setRemoteWebdriverWaitTimeoutSec(int value) {
        this.remoteWebdriverWaitTimeoutSec.setValue((Object)value);
        return this;
    }

    public int getRemoteWebdriverPollTimeSec() {
        return this.resolve(this.remoteWebdriverPollTimeSec);
    }

    public Config setRemoteWebdriverPollTimeSec(int value) {
        this.remoteWebdriverPollTimeSec.setValue((Object)value);
        return this;
    }

    public int getTtlSec() {
        return this.resolve(this.ttlSec);
    }

    public Config setTtlSec(int value) {
        this.ttlSec.setValue((Object)value);
        return this;
    }

    public boolean isUsePreferences() {
        return this.resolve(this.usePreferences);
    }

    public Config setUsePreferences(boolean value) {
        this.usePreferences.setValue((Object)value);
        return this;
    }

    public void useSurefireOutputFolder() {
        this.outputFolder.setValue((Object)"surefire-reports");
    }

    public void enableScreenshotAtTheEndOfTests() {
        this.screenshotAtTheEndOfTests.setValue((Object)"true");
    }

    public void disableScreenshotAtTheEndOfTests() {
        this.screenshotAtTheEndOfTests.setValue((Object)"false");
    }

    public void takeScreenshotAsBase64() {
        this.screenshotFormat.setValue((Object)"base64");
    }

    public void takeScreenshotAsPng() {
        this.screenshotFormat.setValue((Object)"png");
    }

    public void takeScreenshotAsBase64AndPng() {
        this.screenshotFormat.setValue((Object)"base64andpng");
    }

    public WebDriverManager chromedriver() {
        return WebDriverManager.chromedriver();
    }

    public WebDriverManager edgedriver() {
        return WebDriverManager.edgedriver();
    }

    public WebDriverManager firefoxdriver() {
        return WebDriverManager.firefoxdriver();
    }

    public WebDriverManager iedriver() {
        return WebDriverManager.iedriver();
    }

    public WebDriverManager operadriver() {
        return WebDriverManager.operadriver();
    }

    public WebDriverManager phantomjs() {
        return WebDriverManager.phantomjs();
    }
}

