/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverHandler
extends DriverHandler {
    public EdgeDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            EdgeOptions edgeOptions = (EdgeOptions)this.getOptions(this.parameter, testInstance);
            if (capabilities.isPresent()) {
                edgeOptions.merge(capabilities.get());
            }
            this.object = new EdgeDriver(edgeOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        EdgeOptions edgeOptions = new EdgeOptions();
        EdgeOptions optionsFromAnnotatedField = this.annotationsReader.getOptionsFromAnnotatedField(testInstance, Options.class, EdgeOptions.class);
        if (optionsFromAnnotatedField != null) {
            edgeOptions = optionsFromAnnotatedField;
        }
        return edgeOptions;
    }
}

