/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Arguments;
import io.github.bonigarcia.seljup.Binary;
import io.github.bonigarcia.seljup.Extensions;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;

public class OperaDriverHandler
extends DriverHandler {
    public OperaDriverHandler(Config config, AnnotationsReader annotationsReader) {
        super(config, annotationsReader);
    }

    public OperaDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            OperaOptions operaOptions = (OperaOptions)this.getOptions(this.parameter, testInstance);
            if (capabilities.isPresent()) {
                operaOptions.merge(capabilities.get());
            }
            this.object = new OperaDriver(operaOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        OperaOptions operaOptions = new OperaOptions();
        if (parameter != null) {
            OperaOptions optionsFromAnnotatedField;
            Binary binary;
            Extensions extensions;
            Arguments arguments = parameter.getAnnotation(Arguments.class);
            if (arguments != null) {
                Arrays.stream(arguments.value()).forEach(xva$0 -> operaOptions.addArguments(new String[]{xva$0}));
            }
            if ((extensions = parameter.getAnnotation(Extensions.class)) != null) {
                for (String extension : extensions.value()) {
                    operaOptions.addExtensions(new File[]{this.getExtension(extension)});
                }
            }
            if ((binary = parameter.getAnnotation(Binary.class)) != null) {
                operaOptions.setBinary(binary.value());
            }
            if ((optionsFromAnnotatedField = this.annotationsReader.getOptionsFromAnnotatedField(testInstance, Options.class, OperaOptions.class)) != null) {
                operaOptions = optionsFromAnnotatedField.merge((Capabilities)operaOptions);
            }
        }
        return operaOptions;
    }
}

