/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.CloudType;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.ChromeDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import io.github.bonigarcia.seljup.handler.EdgeDriverHandler;
import io.github.bonigarcia.seljup.handler.FirefoxDriverHandler;
import io.github.bonigarcia.seljup.handler.InternetExplorerDriverHandler;
import io.github.bonigarcia.seljup.handler.OperaDriverHandler;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserInstance {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    BrowserType browserType;
    CloudType cloudType;
    String dockerImage;
    String browserName;
    String path;
    DriverHandler driverHandler;
    String optionsKey;
    DesiredCapabilities capabilities;
    List<String> volumes;

    public BrowserInstance(Config config, AnnotationsReader annotationsReader, BrowserType browserType, CloudType cloudType, Optional<String> browserName, Optional<String[]> volumes) {
        this.config = config;
        this.browserType = browserType;
        this.cloudType = cloudType;
        if (volumes.isPresent()) {
            this.volumes = Arrays.asList((Object[])volumes.get());
        }
        if (browserName.isPresent()) {
            this.browserName = browserName.get();
        }
        switch (browserType) {
            case FIREFOX: {
                this.dockerImage = config.getFirefoxImageFormat();
                this.path = config.getFirefoxPath();
                this.driverHandler = new FirefoxDriverHandler(config, annotationsReader);
                this.optionsKey = "moz:firefoxOptions";
                this.capabilities = new DesiredCapabilities("firefox", "", Platform.ANY);
                break;
            }
            case OPERA: {
                this.dockerImage = config.getOperaImageFormat();
                this.path = config.getOperaPath();
                this.driverHandler = new OperaDriverHandler(config, annotationsReader);
                this.optionsKey = "operaOptions";
                this.capabilities = new DesiredCapabilities("operablink", "", Platform.ANY);
                break;
            }
            case EDGE: {
                this.dockerImage = config.getEdgeImage();
                this.path = config.getEdgePath();
                this.driverHandler = new EdgeDriverHandler(config, annotationsReader);
                this.optionsKey = "edgeOptions";
                this.capabilities = new DesiredCapabilities("microsoftedge", "", Platform.ANY);
                break;
            }
            case IEXPLORER: {
                this.dockerImage = config.getIExplorerImage();
                this.path = config.getIExplorerPath();
                this.driverHandler = new InternetExplorerDriverHandler(config, annotationsReader);
                this.optionsKey = "se:ieOptions";
                this.capabilities = new DesiredCapabilities("iexplorer", "", Platform.ANY);
                break;
            }
            default: {
                this.dockerImage = config.getChromeImageFormat();
                this.path = config.getChromePath();
                this.driverHandler = new ChromeDriverHandler(config, annotationsReader);
                this.optionsKey = "goog:chromeOptions";
                this.capabilities = new DesiredCapabilities("chrome", "", Platform.ANY);
            }
        }
    }

    public String getNextVersion(String version, String latestVersion) {
        int iVersion = version.indexOf(46);
        iVersion = iVersion != -1 ? iVersion : version.length();
        int nextVersionInt = Integer.parseInt(version.substring(0, iVersion)) + 1;
        int iLatestVersion = latestVersion.indexOf(46);
        int latestVersionInt = Integer.parseInt(latestVersion.substring(0, iLatestVersion = iLatestVersion != -1 ? iLatestVersion : latestVersion.length())) + 1;
        if (nextVersionInt > latestVersionInt) {
            return null;
        }
        return String.valueOf(nextVersionInt) + ".0";
    }

    public String getPath() {
        return this.path;
    }

    public DriverHandler getDriverHandler() {
        return this.driverHandler;
    }

    public String getOptionsKey() {
        return this.optionsKey;
    }

    public String getDockerImage(String version) {
        return String.format(this.getDockerImage(), version);
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public CloudType getCloudType() {
        return this.cloudType;
    }

    public String getBrowserTypeAsString() {
        return this.browserType.name();
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }
}

