/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import io.appium.java_client.AppiumDriver;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowsersTemplate;
import io.github.bonigarcia.seljup.DockerContainer;
import io.github.bonigarcia.seljup.DockerService;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.ScreenshotManager;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.SelenoidService;
import io.github.bonigarcia.seljup.SingleSession;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.AppiumDriverHandler;
import io.github.bonigarcia.seljup.handler.ChromeDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import io.github.bonigarcia.seljup.handler.EdgeDriverHandler;
import io.github.bonigarcia.seljup.handler.FirefoxDriverHandler;
import io.github.bonigarcia.seljup.handler.InternetExplorerDriverHandler;
import io.github.bonigarcia.seljup.handler.ListDriverHandler;
import io.github.bonigarcia.seljup.handler.OperaDriverHandler;
import io.github.bonigarcia.seljup.handler.OtherDriverHandler;
import io.github.bonigarcia.seljup.handler.RemoteDriverHandler;
import io.github.bonigarcia.seljup.handler.SafariDriverHandler;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumExtension
implements ParameterResolver,
AfterEachCallback,
AfterAllCallback,
TestTemplateInvocationContextProvider {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String CLASSPATH_PREFIX = "classpath:";
    private Config config = new Config();
    private AnnotationsReader annotationsReader = new AnnotationsReader();
    private InternalPreferences preferences = new InternalPreferences(this.getConfig());
    private List<Class<?>> typeList = new CopyOnWriteArrayList();
    private Map<String, List<DriverHandler>> driverHandlerMap = new ConcurrentHashMap<String, List<DriverHandler>>();
    private Map<String, Class<?>> handlerMap = new ConcurrentHashMap();
    private Map<String, Class<?>> templateHandlerMap = new ConcurrentHashMap();
    private Map<String, Map<String, DockerContainer>> containersMap = new ConcurrentHashMap<String, Map<String, DockerContainer>>();
    private DockerService dockerService;
    private Map<String, List<BrowsersTemplate.Browser>> browserListMap = new ConcurrentHashMap<String, List<BrowsersTemplate.Browser>>();
    private List<List<BrowsersTemplate.Browser>> browserListList;

    public SeleniumExtension() {
        this.addEntry(this.handlerMap, "org.openqa.selenium.chrome.ChromeDriver", ChromeDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.firefox.FirefoxDriver", FirefoxDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.edge.EdgeDriver", EdgeDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.opera.OperaDriver", OperaDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.safari.SafariDriver", SafariDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.remote.RemoteWebDriver", RemoteDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.WebDriver", RemoteDriverHandler.class);
        this.addEntry(this.handlerMap, "io.appium.java_client.AppiumDriver", AppiumDriverHandler.class);
        this.addEntry(this.handlerMap, "java.util.List", ListDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.phantomjs.PhantomJSDriver", OtherDriverHandler.class);
        this.addEntry(this.handlerMap, "org.openqa.selenium.ie.InternetExplorerDriver", InternetExplorerDriverHandler.class);
        this.addEntry(this.templateHandlerMap, "chrome", ChromeDriver.class);
        this.addEntry(this.templateHandlerMap, "firefox", FirefoxDriver.class);
        this.addEntry(this.templateHandlerMap, "edge", EdgeDriver.class);
        this.addEntry(this.templateHandlerMap, "opera", OperaDriver.class);
        this.addEntry(this.templateHandlerMap, "safari", SafariDriver.class);
        this.addEntry(this.templateHandlerMap, "appium", AppiumDriver.class);
        this.addEntry(this.templateHandlerMap, "phantomjs", PhantomJSDriver.class);
        this.addEntry(this.templateHandlerMap, "iexplorer", InternetExplorerDriver.class);
        this.addEntry(this.templateHandlerMap, "internet explorer", InternetExplorerDriver.class);
        this.addEntry(this.templateHandlerMap, "chrome-in-docker", RemoteWebDriver.class);
        this.addEntry(this.templateHandlerMap, "firefox-in-docker", RemoteWebDriver.class);
        this.addEntry(this.templateHandlerMap, "opera-in-docker", RemoteWebDriver.class);
        this.addEntry(this.templateHandlerMap, "android", RemoteWebDriver.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return (WebDriver.class.isAssignableFrom(type) || type.equals(List.class)) && !this.isTestTemplate(extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional<String> urlFromAnnotation;
        Object obj;
        List<DriverHandler> list;
        String contextId = extensionContext.getUniqueId();
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        this.log.debug("Context id {}", (Object)contextId);
        if (this.isSingleSession(extensionContext) && this.driverHandlerMap.containsKey(contextId) && index < (list = this.driverHandlerMap.get(contextId)).size() && (obj = list.get(index).getObject()) != null) {
            this.log.debug("Returning index {}: {}", (Object)index, obj);
            return obj;
        }
        Class<?> type = parameter.getType();
        String url = null;
        BrowsersTemplate.Browser browser = null;
        if (this.isGeneric(type) && !this.browserListMap.isEmpty()) {
            browser = this.getBrowser(contextId, index);
        }
        if ((urlFromAnnotation = this.getUrlFromAnnotation(parameter, extensionContext)).isPresent() && browser != null) {
            browser.setUrl(urlFromAnnotation.get());
        }
        if (browser != null) {
            type = this.templateHandlerMap.get(browser.getType());
            url = browser.getUrl();
        }
        Class constructorClass = this.handlerMap.containsKey(type.getName()) ? this.handlerMap.get(type.getName()) : OtherDriverHandler.class;
        boolean isRemote = constructorClass.equals(RemoteDriverHandler.class);
        if (url != null && !url.isEmpty()) {
            constructorClass = RemoteDriverHandler.class;
            isRemote = true;
        }
        this.runWebDriverManagerIfNeded(type, isRemote);
        DriverHandler driverHandler = this.getDriverHandler(parameterContext, extensionContext, parameter, type, browser, constructorClass, isRemote);
        return this.resolveHandler(parameter, driverHandler);
    }

    private DriverHandler getDriverHandler(ParameterContext parameterContext, ExtensionContext extensionContext, Parameter parameter, Class<?> type, BrowsersTemplate.Browser browser, Class<?> constructorClass, boolean isRemote) {
        DriverHandler driverHandler = null;
        try {
            boolean isTemplate;
            driverHandler = this.getDriverHandler(extensionContext, parameter, type, constructorClass, browser, isRemote);
            String contextId = extensionContext.getUniqueId();
            if (type.equals(RemoteWebDriver.class) || type.equals(WebDriver.class) || type.equals(List.class)) {
                this.initHandlerForDocker(contextId, driverHandler);
            }
            if (!(isTemplate = this.isTestTemplate(extensionContext)) && this.isGeneric(type) && isRemote) {
                ((RemoteDriverHandler)driverHandler).setParent(this);
                ((RemoteDriverHandler)driverHandler).setParameterContext(parameterContext);
            }
            this.putDriverHandlerInMap(extensionContext.getUniqueId(), driverHandler);
        }
        catch (Exception e) {
            this.handleException(parameter, driverHandler, constructorClass, e);
        }
        return driverHandler;
    }

    private void runWebDriverManagerIfNeded(Class<?> type, boolean isRemote) {
        if (!this.typeList.contains(type) && !isRemote) {
            WebDriverManager.getInstance(type).setup();
            this.typeList.add(type);
        }
    }

    private void putDriverHandlerInMap(String contextId, DriverHandler driverHandler) {
        String newContextId = this.searchContextIdKeyInMap(this.driverHandlerMap, contextId);
        this.log.trace("Put driver handler {} in map (context id {}, new context id {})", new Object[]{driverHandler, contextId, newContextId});
        if (this.driverHandlerMap.containsKey(contextId)) {
            this.driverHandlerMap.get(contextId).add(driverHandler);
            this.log.trace("Adding {} to handler existing map (id {})", (Object)driverHandler, (Object)contextId);
        } else if (this.driverHandlerMap.containsKey(newContextId)) {
            this.driverHandlerMap.get(newContextId).add(driverHandler);
            this.log.trace("Adding {} to handler existing map (new id {})", (Object)driverHandler, (Object)newContextId);
        } else {
            ArrayList<DriverHandler> driverHandlers = new ArrayList<DriverHandler>();
            driverHandlers.add(driverHandler);
            this.driverHandlerMap.put(contextId, driverHandlers);
            this.log.trace("Adding {} to handler new map (id {})", (Object)driverHandler, (Object)contextId);
        }
    }

    private BrowsersTemplate.Browser getBrowser(String contextId, int index) {
        BrowsersTemplate.Browser browser = null;
        List<BrowsersTemplate.Browser> browserList = this.getValueFromContextId(this.browserListMap, contextId);
        if (browserList == null) {
            this.log.warn("Browser list for context id {} not found", (Object)contextId);
        } else {
            if (index >= browserList.size()) {
                index = browserList.size() - 1;
            }
            browser = browserList.get(index);
        }
        return browser;
    }

    private Object resolveHandler(Parameter parameter, DriverHandler driverHandler) {
        if (driverHandler != null) {
            driverHandler.resolve();
            return driverHandler.getObject();
        }
        if (this.getConfig().isExceptionWhenNoDriver()) {
            throw new SeleniumJupiterException("No valid handler for " + parameter + " was found");
        }
        return null;
    }

    private DriverHandler getDriverHandler(ExtensionContext extensionContext, Parameter parameter, Class<?> type, Class<?> constructorClass, BrowsersTemplate.Browser browser, boolean isRemote) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        DriverHandler driverHandler = null;
        driverHandler = isRemote && browser != null ? (DriverHandler)constructorClass.getDeclaredConstructor(Parameter.class, ExtensionContext.class, Config.class, AnnotationsReader.class, BrowsersTemplate.Browser.class).newInstance(parameter, extensionContext, this.getConfig(), this.getAnnotationsReader(), browser) : (constructorClass.equals(OtherDriverHandler.class) && !this.browserListMap.isEmpty() ? (DriverHandler)constructorClass.getDeclaredConstructor(Parameter.class, ExtensionContext.class, Config.class, AnnotationsReader.class, Class.class).newInstance(parameter, extensionContext, this.getConfig(), this.getAnnotationsReader(), type) : (DriverHandler)constructorClass.getDeclaredConstructor(Parameter.class, ExtensionContext.class, Config.class, AnnotationsReader.class).newInstance(parameter, extensionContext, this.getConfig(), this.getAnnotationsReader()));
        return driverHandler;
    }

    private Optional<String> getUrlFromAnnotation(Parameter parameter, ExtensionContext extensionContext) {
        Optional<String> out = Optional.empty();
        try {
            Optional<URL> urlFromAnnotation = this.annotationsReader.getUrl(parameter, extensionContext.getTestInstance(), this.config.getSeleniumServerUrl());
            if (urlFromAnnotation.isPresent()) {
                out = Optional.of(urlFromAnnotation.get().toString());
            }
        }
        catch (Exception e) {
            this.log.warn("Exception getting URL from annotation", (Throwable)e);
        }
        return out;
    }

    public void initHandlerForDocker(String contextId, DriverHandler driverHandler) {
        LinkedHashMap<String, DockerContainer> containerMap = new LinkedHashMap<String, DockerContainer>();
        driverHandler.setContainerMap(containerMap);
        this.log.trace("Adding new container map (context id {}) (handler {})", (Object)contextId, (Object)driverHandler);
        this.containersMap.put(contextId, containerMap);
        if (this.dockerService == null) {
            this.dockerService = new DockerService(this.config, this.preferences);
        }
        driverHandler.setDockerService(this.dockerService);
    }

    private void handleException(Parameter parameter, DriverHandler driverHandler, Class<?> constructorClass, Exception e) {
        if (driverHandler != null && driverHandler.throwExceptionWhenNoDriver()) {
            this.log.error("Exception resolving {}", (Object)parameter, (Object)e);
            throw new SeleniumJupiterException(e);
        }
        this.log.warn("Exception creating {}", constructorClass, (Object)e);
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (!this.isSingleSession(extensionContext)) {
            this.teardown(extensionContext);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (!this.driverHandlerMap.isEmpty()) {
            this.teardown(extensionContext);
        }
    }

    private boolean isGeneric(Class<?> type) {
        return type.equals(RemoteWebDriver.class) || type.equals(WebDriver.class);
    }

    private boolean isSingleSession(ExtensionContext extensionContext) {
        boolean singleSession = extensionContext.getTestClass().isPresent() && ((Class)extensionContext.getTestClass().get()).isAnnotationPresent(SingleSession.class);
        this.log.trace("Single session {}", (Object)singleSession);
        return singleSession;
    }

    private void teardown(ExtensionContext extensionContext) {
        ScreenshotManager screenshotManager = new ScreenshotManager(extensionContext, this.getConfig());
        String contextId = extensionContext.getUniqueId();
        this.log.trace("After each for context id {}", (Object)contextId);
        List<DriverHandler> driverHandlers = this.getValueFromContextId(this.driverHandlerMap, contextId);
        if (driverHandlers == null) {
            this.log.warn("Driver handler for context id {} not found", (Object)contextId);
            return;
        }
        for (DriverHandler driverHandler : ImmutableList.copyOf(driverHandlers).reverse()) {
            Object object = driverHandler.getObject();
            try {
                this.quitWebDriver(object, driverHandler, screenshotManager);
            }
            catch (Exception e) {
                this.log.warn("Exception closing webdriver object {}", object, (Object)e);
            }
            try {
                driverHandler.cleanup();
            }
            catch (Exception e) {
                this.log.warn("Exception cleaning handler {}", (Object)driverHandler, (Object)e);
            }
        }
        this.driverHandlerMap.remove(contextId);
    }

    private void quitWebDriver(Object object, DriverHandler driverHandler, ScreenshotManager screenshotManager) {
        if (object != null) {
            if (List.class.isAssignableFrom(object.getClass())) {
                List webDriverList = (List)object;
                for (int i = 0; i < webDriverList.size(); ++i) {
                    screenshotManager.makeScreenshot((WebDriver)webDriverList.get(i), driverHandler.getName() + "_" + i);
                    ((RemoteWebDriver)webDriverList.get(i)).quit();
                }
            } else {
                WebDriver webDriver = (WebDriver)object;
                if (driverHandler.getName() != null) {
                    screenshotManager.makeScreenshot(webDriver, driverHandler.getName());
                }
                webDriver.quit();
            }
        }
    }

    private <T> T getValueFromContextId(Map<String, T> map, String contextId) {
        String newContextId = this.searchContextIdKeyInMap(map, contextId);
        return map.get(newContextId);
    }

    private String searchContextIdKeyInMap(Map<String, ?> map, String contextId) {
        int i;
        if (!map.containsKey(contextId) && (i = contextId.lastIndexOf(47)) != -1) {
            contextId = contextId.substring(0, i);
        }
        return contextId;
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        boolean allWebDriver = false;
        if (context.getTestMethod().isPresent()) {
            allWebDriver = !Arrays.stream(((Method)context.getTestMethod().get()).getParameterTypes()).map(s -> s.equals(WebDriver.class) || s.equals(RemoteWebDriver.class)).collect(Collectors.toList()).contains(false);
        }
        return allWebDriver;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        String contextId = extensionContext.getUniqueId();
        try {
            String browserJsonContent = this.getConfig().getBrowserTemplateJsonContent();
            if (browserJsonContent.isEmpty()) {
                String browserJsonFile = this.getConfig().getBrowserTemplateJsonFile();
                if (browserJsonFile.startsWith(CLASSPATH_PREFIX)) {
                    String browserJsonInClasspath = browserJsonFile.substring(CLASSPATH_PREFIX.length());
                    InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + browserJsonInClasspath);
                    if (resourceAsStream != null) {
                        browserJsonContent = IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
                    }
                } else {
                    browserJsonContent = new String(Files.readAllBytes(Paths.get(browserJsonFile, new String[0])));
                }
            }
            if (!browserJsonContent.isEmpty()) {
                return ((BrowsersTemplate)new Gson().fromJson(browserJsonContent, BrowsersTemplate.class)).getStream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            if (this.browserListList != null) {
                return this.browserListList.stream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            if (this.browserListMap != null) {
                return Stream.of(this.invocationContext(this.browserListMap.get(contextId), this));
            }
        }
        catch (IOException e) {
            throw new SeleniumJupiterException(e);
        }
        throw new SeleniumJupiterException("No browser scenario registered for test template");
    }

    private synchronized TestTemplateInvocationContext invocationContext(final List<BrowsersTemplate.Browser> template, final SeleniumExtension parent) {
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return template.toString();
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new ParameterResolver(){

                    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        Class<?> type = parameterContext.getParameter().getType();
                        return type.equals(WebDriver.class) || type.equals(RemoteWebDriver.class);
                    }

                    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        String contextId = extensionContext.getUniqueId();
                        SeleniumExtension.this.log.trace("Setting browser list {} for context id {}", (Object)template, (Object)contextId);
                        parent.browserListMap.put(contextId, template);
                        return parent.resolveParameter(parameterContext, extensionContext);
                    }
                });
            }
        };
    }

    private void addEntry(Map<String, Class<?>> map, String key, Class<?> value) {
        try {
            map.put(key, value);
        }
        catch (Exception e) {
            this.log.warn("Exception adding {}={} to handler map ({})", new Object[]{key, value, e.getMessage()});
        }
    }

    private boolean isTestTemplate(ExtensionContext extensionContext) {
        Optional testMethod = extensionContext.getTestMethod();
        return testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(TestTemplate.class);
    }

    public void putBrowserList(String key, List<BrowsersTemplate.Browser> browserList) {
        this.browserListMap.put(key, browserList);
    }

    public void addBrowsers(BrowsersTemplate.Browser ... browsers) {
        if (this.browserListList == null) {
            this.browserListList = new ArrayList<List<BrowsersTemplate.Browser>>();
        }
        this.browserListList.add(Arrays.asList(browsers));
    }

    public Optional<String> getContainerId(WebDriver driver) {
        try {
            for (Map.Entry<String, Map<String, DockerContainer>> entry : this.containersMap.entrySet()) {
                DockerContainer selenoidContainer = this.containersMap.get(entry.getKey()).values().iterator().next();
                URL selenoidUrl = new URL(selenoidContainer.getContainerUrl());
                URL selenoidBaseUrl = new URL(selenoidUrl.getProtocol(), selenoidUrl.getHost(), selenoidUrl.getPort(), "/");
                SelenoidService selenoidService = new SelenoidService(selenoidBaseUrl.toString());
                Optional<String> containerId = selenoidService.getContainerId(driver);
                if (!containerId.isPresent()) continue;
                return containerId;
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new SeleniumJupiterException(e);
        }
    }

    public DockerService getDockerService() {
        return this.dockerService;
    }

    public Config getConfig() {
        return this.config;
    }

    public AnnotationsReader getAnnotationsReader() {
        return this.annotationsReader;
    }

    public void clearPreferences() {
        this.preferences.clear();
    }
}

