/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class BrowserManager {
    protected static final Logger log = LoggerFactory.getLogger(BrowserManager.class);
    private final String SEPARATOR = "/";
    protected String latestVersion = null;

    protected abstract List<URL> getDrivers(Architecture var1) throws Exception;

    protected abstract String getExportParameter();

    public void manage() {
        String myArchitecture = System.getProperty("sun.arch.data.model");
        this.manage(Architecture.valueOf("x" + myArchitecture));
    }

    public void manage(Architecture arch) {
        try {
            List<URL> urls = this.getDrivers(arch);
            List<URL> urlFilter = this.filter(arch, urls);
            for (URL url : urls) {
                String export = urlFilter.contains(url) ? this.getExportParameter() : null;
                new Downloader().download(url, this.latestVersion, export);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> filter(Architecture arch, List<URL> list) {
        ArrayList<URL> out = new ArrayList<URL>();
        String mySystem = System.getProperty("os.name").toLowerCase();
        for (URL url : list) {
            for (OperativeSystem os : OperativeSystem.values()) {
                if (!mySystem.contains(os.name()) || !url.getFile().toLowerCase().contains(os.name())) continue;
                out.add(url);
            }
        }
        if (out.size() > 1) {
            for (URL url : list) {
                if (url.getFile().contains(arch.toString())) continue;
                out.remove(url);
            }
        }
        return out;
    }

    public List<URL> getLatest(List<URL> list, String match) {
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        for (URL url : list) {
            if (!url.getFile().contains(match)) continue;
            String currentVersion = url.getFile().substring(url.getFile().indexOf("/") + 1, url.getFile().lastIndexOf("/"));
            if (this.latestVersion == null) {
                this.latestVersion = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.latestVersion) > 0) {
                this.latestVersion = currentVersion;
                out.clear();
            }
            if (!url.getFile().contains(this.latestVersion)) continue;
            out.add(url);
        }
        log.info("Latest driver version: {}", (Object)this.latestVersion);
        return out;
    }

    public Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public List<URL> getDriversFromXml(Architecture arch, URL driverUrl, String driverBinary) throws Exception {
        log.info("Connecting to {} to check lastest {} release", (Object)driverUrl, (Object)driverBinary);
        BufferedReader reader = new BufferedReader(new InputStreamReader(driverUrl.openStream()));
        Document xml = this.loadXML(reader);
        List<URL> urls = new ArrayList<URL>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String version = e.getChildNodes().item(0).getNodeValue();
            urls.add(new URL(driverUrl + version));
        }
        urls = this.getLatest(urls, driverBinary);
        if (WdmConfig.getBoolean("wdm.downloadJustForMySystem")) {
            urls = this.filter(arch, urls);
        }
        reader.close();
        return urls;
    }

    public Document loadXML(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }
}

