/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverVersion;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class BrowserManager {
    protected static final Logger log = LoggerFactory.getLogger(BrowserManager.class);
    private final String SEPARATOR = "/";
    private static final String VERSION_PROPERTY = "wdm.driverVersion";
    private static final Architecture DEFAULT_ARCH = Architecture.valueOf("x" + System.getProperty("sun.arch.data.model"));
    protected String versionToDownload;

    protected abstract List<URL> getDrivers(Architecture var1, String var2) throws Exception;

    protected abstract String getExportParameter();

    public void manage(Architecture arch, DriverVersion version) {
        this.manage(arch, version.name());
    }

    public void manage(Architecture arch, String version) {
        try {
            List<URL> urls = this.getDrivers(arch, version);
            List<URL> urlFilter = this.filter(arch, urls);
            for (URL url : urls) {
                String export = urlFilter.contains(url) ? this.getExportParameter() : null;
                Downloader.download(url, this.versionToDownload, export);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> filter(Architecture arch, List<URL> list) {
        ArrayList<URL> out = new ArrayList<URL>();
        String mySystem = System.getProperty("os.name").toLowerCase();
        for (URL url : list) {
            for (OperativeSystem os : OperativeSystem.values()) {
                if (!mySystem.contains(os.name()) || !url.getFile().toLowerCase().contains(os.name())) continue;
                out.add(url);
            }
        }
        if (out.size() > 1) {
            for (URL url : list) {
                if (url.getFile().contains(arch.toString())) continue;
                out.remove(url);
            }
        }
        return out;
    }

    public List<URL> getVersion(List<URL> list, String match, String version) {
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        for (URL url : list) {
            if (!url.getFile().contains(match) || !url.getFile().contains(version)) continue;
            out.add(url);
        }
        if (out.isEmpty()) {
            throw new RuntimeException("Version " + version + " is not available for " + match);
        }
        this.versionToDownload = version;
        System.setProperty(VERSION_PROPERTY, this.versionToDownload);
        log.info("Using {} {}", (Object)match, (Object)version);
        return out;
    }

    public List<URL> getLatest(List<URL> list, String match) {
        log.info("Checking the lastest version of {}", (Object)match);
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        for (URL url : list) {
            if (!url.getFile().contains(match)) continue;
            String currentVersion = url.getFile().substring(url.getFile().indexOf("/") + 1, url.getFile().lastIndexOf("/"));
            if (this.versionToDownload == null) {
                this.versionToDownload = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                this.versionToDownload = currentVersion;
                out.clear();
            }
            if (!url.getFile().contains(this.versionToDownload)) continue;
            out.add(url);
        }
        System.setProperty(VERSION_PROPERTY, this.versionToDownload);
        log.info("Using {} {}", (Object)match, (Object)this.versionToDownload);
        return out;
    }

    public Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public List<URL> getDriversFromXml(Architecture arch, URL driverUrl, String driverBinary, String driverVersion) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(driverUrl.openStream()));
        Document xml = this.loadXML(reader);
        List<URL> urls = new ArrayList<URL>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String version = e.getChildNodes().item(0).getNodeValue();
            urls.add(new URL(driverUrl + version));
        }
        urls = driverVersion == null || driverVersion.isEmpty() || driverVersion.equalsIgnoreCase(DriverVersion.LATEST.name()) ? this.getLatest(urls, driverBinary) : this.getVersion(urls, driverBinary, driverVersion);
        if (WdmConfig.getBoolean("wdm.downloadJustForMySystem")) {
            urls = this.filter(arch, urls);
        }
        reader.close();
        return urls;
    }

    public Document loadXML(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    public void setup() {
        try {
            ((BrowserManager)this.getClass().newInstance()).manage(DEFAULT_ARCH, DriverVersion.NOT_SPECIFIED);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setup(Architecture arch, String version) {
        try {
            ((BrowserManager)this.getClass().newInstance()).manage(arch, version);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setup(String version) {
        try {
            ((BrowserManager)this.getClass().newInstance()).manage(DEFAULT_ARCH, version);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setup(Architecture arch) {
        try {
            ((BrowserManager)this.getClass().newInstance()).manage(arch, DriverVersion.NOT_SPECIFIED);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDriverVersion() {
        return System.getProperty(VERSION_PROPERTY);
    }
}

