/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String TTL = "-ttl";
    java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(WebDriverManager.class);
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String getVersionInPreferences(String key) {
        return this.prefs.get(key, null);
    }

    public long getExpirationTimeInPreferences(String key) {
        return this.prefs.getLong(this.getExpirationKey(key), 0L);
    }

    public void putVersionInPreferencesIfEmpty(String key, String value) {
        if (this.getVersionInPreferences(key) == null) {
            this.prefs.put(key, value);
            long expirationTime = new Date().getTime() + TimeUnit.SECONDS.toMillis(WebDriverManager.config().getTtl());
            this.prefs.putLong(this.getExpirationKey(key), expirationTime);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing version {} for {} as Java preferences (valid until {})", new Object[]{value, key, this.formatTime(expirationTime)});
            }
        }
    }

    public void clearVersionFromPreferences(String key) {
        this.prefs.remove(key);
        this.prefs.remove(this.getExpirationKey(key));
    }

    public void clear() {
        try {
            this.log.info("Clearing WebDriverManager preferences");
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            this.log.warn("Exception clearing preferences", (Throwable)e);
        }
    }

    public boolean checkVersionValidity(String key, String version, long expirationTime) {
        long now = new Date().getTime();
        boolean validVersion = version != null && expirationTime != 0L && expirationTime > now;
        String expirationDate = this.formatTime(expirationTime);
        String nowDate = this.formatTime(now);
        this.log.trace("checkVersionValidity: version={} expirationDate={} now={} -- result={}", new Object[]{version, expirationDate, nowDate, validVersion});
        if (!validVersion) {
            this.log.debug("Removing preference {} {} (expired on {})", new Object[]{key, version, expirationDate});
            this.clearVersionFromPreferences(key);
        }
        return validVersion;
    }

    public String formatTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private String getExpirationKey(String key) {
        return key + TTL;
    }
}

