/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.Shell;
import io.github.bonigarcia.wdm.VersionComparator;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends WebDriverManager {
    protected EdgeDriverManager() {
        this.driverManagerType = DriverManagerType.EDGE;
        this.exportParameterKey = "wdm.edgeDriverExport";
        this.driverVersionKey = "wdm.edgeDriverVersion";
        this.driverUrlKey = "wdm.edgeDriverUrl";
        this.driverName = "MicrosoftWebDriver";
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        this.listVersions = new ArrayList();
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL driverUrl = EdgeDriverManager.config().getDriverUrl(this.driverUrlKey);
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)driverUrl);
        try (InputStream in = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl)).getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Elements downloadLink = doc.select("ul.driver-downloads li.driver-download > a");
            Elements versionParagraph = doc.select("ul.driver-downloads li.driver-download p.driver-download__meta");
            versionParagraph.remove(0);
            versionParagraph.remove(0);
            versionParagraph.remove(0);
            for (int i = 0; i < downloadLink.size(); ++i) {
                String[] version = ((Element)versionParagraph.get(i)).text().split(" ");
                String v = version[1];
                if (v.equalsIgnoreCase("version")) continue;
                this.listVersions.add(v);
                urlList.add(new URL(((Element)downloadLink.get(i)).attr("href")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    @Override
    public List<String> getVersions() {
        this.httpClient = new HttpClient(EdgeDriverManager.config().getTimeout());
        try {
            this.getDrivers();
            Collections.sort(this.listVersions, new VersionComparator());
            return this.listVersions;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    @Override
    protected List<URL> checkLatest(List<URL> list, String driver) {
        log.trace("Checking the lastest version of {} with URL list {}", (Object)driver, list);
        ArrayList<URL> out = new ArrayList<URL>();
        this.versionToDownload = (String)this.listVersions.iterator().next();
        out.add(list.iterator().next());
        log.info("Latest version of MicrosoftWebDriver is {}", (Object)this.versionToDownload);
        return out;
    }

    @Override
    protected File postDownload(File archive) {
        Collection listFiles = FileUtils.listFiles((File)new File(archive.getParent()), (String[])new String[]{"exe"}, (boolean)true);
        return (File)listFiles.iterator().next();
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        String browserVersionOutput;
        if (SystemUtils.IS_OS_WINDOWS && !Config.isNullOrEmpty(browserVersionOutput = Shell.runAndWait("powershell", "get-appxpackage Microsoft.MicrosoftEdge"))) {
            return Optional.of(Shell.getVersionFromPowerShellOutput(browserVersionOutput));
        }
        return Optional.empty();
    }
}

