/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.OperatingSystem;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.Preferences;
import io.github.bonigarcia.wdm.SeleniumServerStandaloneManager;
import io.github.bonigarcia.wdm.Server;
import io.github.bonigarcia.wdm.Shell;
import io.github.bonigarcia.wdm.UrlFilter;
import io.github.bonigarcia.wdm.VersionComparator;
import io.github.bonigarcia.wdm.VoidDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static final String PRE_INSTALLED = "pre-installed";
    protected static final String BETA = "beta";
    protected static final String ONLINE = "online";
    protected static final String LOCAL = "local";
    protected static Map<DriverManagerType, WebDriverManager> instanceMap = new EnumMap<DriverManagerType, WebDriverManager>(DriverManagerType.class);
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected UrlFilter urlFilter;
    protected String versionToDownload;
    protected String downloadedVersion;
    protected String latestVersion;
    protected String binaryPath;
    protected boolean mirrorLog;
    protected List<String> listVersions;
    protected boolean forcedArch;
    protected boolean forcedOs;
    protected boolean isLatest;
    protected boolean retry = true;
    protected Config config = new Config();
    protected Preferences preferences = new Preferences(this.config);
    protected String preferenceKey;
    protected Properties versionsProperties;

    protected abstract List<URL> getDrivers() throws IOException;

    protected abstract Optional<String> getBrowserVersion();

    protected abstract DriverManagerType getDriverManagerType();

    protected abstract String getDriverName();

    protected abstract void setDriverVersion(String var1);

    protected abstract String getDriverVersion();

    protected abstract void setDriverUrl(URL var1);

    protected abstract URL getDriverUrl();

    protected abstract Optional<URL> getMirrorUrl();

    protected abstract Optional<String> getExportParameter();

    public static Config globalConfig() {
        Config global = new Config();
        global.setAvoidAutoReset(true);
        for (DriverManagerType type : DriverManagerType.values()) {
            WebDriverManager.getInstance(type).setConfig(global);
        }
        return global;
    }

    public Config config() {
        return this.config;
    }

    public static synchronized WebDriverManager chromedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.CHROME)) {
            instanceMap.put(DriverManagerType.CHROME, new ChromeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.CHROME);
    }

    public static synchronized WebDriverManager firefoxdriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.FIREFOX)) {
            instanceMap.put(DriverManagerType.FIREFOX, new FirefoxDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.FIREFOX);
    }

    public static synchronized WebDriverManager operadriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.OPERA)) {
            instanceMap.put(DriverManagerType.OPERA, new OperaDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.OPERA);
    }

    public static synchronized WebDriverManager edgedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.EDGE)) {
            instanceMap.put(DriverManagerType.EDGE, new EdgeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.EDGE);
    }

    public static synchronized WebDriverManager iedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.IEXPLORER)) {
            instanceMap.put(DriverManagerType.IEXPLORER, new InternetExplorerDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.IEXPLORER);
    }

    public static synchronized WebDriverManager phantomjs() {
        if (!instanceMap.containsKey((Object)DriverManagerType.PHANTOMJS)) {
            instanceMap.put(DriverManagerType.PHANTOMJS, new PhantomJsDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.PHANTOMJS);
    }

    public static synchronized WebDriverManager seleniumServerStandalone() {
        if (!instanceMap.containsKey((Object)DriverManagerType.SELENIUM_SERVER_STANDALONE)) {
            instanceMap.put(DriverManagerType.SELENIUM_SERVER_STANDALONE, new SeleniumServerStandaloneManager());
        }
        return instanceMap.get((Object)DriverManagerType.SELENIUM_SERVER_STANDALONE);
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new VoidDriverManager();
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == null) {
            return WebDriverManager.voiddriver();
        }
        switch (driverManagerType) {
            case CHROME: {
                return WebDriverManager.chromedriver();
            }
            case FIREFOX: {
                return WebDriverManager.firefoxdriver();
            }
            case OPERA: {
                return WebDriverManager.operadriver();
            }
            case IEXPLORER: {
                return WebDriverManager.iedriver();
            }
            case EDGE: {
                return WebDriverManager.edgedriver();
            }
            case PHANTOMJS: {
                return WebDriverManager.phantomjs();
            }
            case SELENIUM_SERVER_STANDALONE: {
                return WebDriverManager.seleniumServerStandalone();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance(Class<?> webDriverClass) {
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public synchronized void setup() {
        if (this.getDriverManagerType() != null) {
            try {
                Architecture architecture = this.config().getArchitecture();
                String driverVersion = this.getDriverVersion();
                this.isLatest = this.isVersionLatest(driverVersion);
                this.manage(architecture, driverVersion);
            }
            finally {
                if (!this.config().isAvoidAutoReset()) {
                    this.reset();
                }
            }
        }
    }

    public WebDriverManager version(String version) {
        this.setDriverVersion(version);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager architecture(Architecture architecture) {
        this.config().setArchitecture(architecture);
        this.forcedArch = true;
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager operatingSystem(OperatingSystem os) {
        this.config().setOs(os.name());
        this.forcedOs = true;
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager forceCache() {
        this.config().setForceCache(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager forceDownload() {
        this.config().setOverride(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        this.setDriverUrl(url);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useMirror() {
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (!mirrorUrl.isPresent()) {
            throw new WebDriverManagerException("Mirror URL not available");
        }
        this.config().setUseMirror(true);
        this.setDriverUrl(mirrorUrl.get());
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxy(String proxy) {
        this.config().setProxy(proxy);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxyUser(String proxyUser) {
        this.config().setProxyUser(proxyUser);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxyPass(String proxyPass) {
        this.config().setProxyPass(proxyPass);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useBetaVersions() {
        this.config().setUseBetaVersions(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager ignoreVersions(String ... versions) {
        this.config().setIgnoreVersions(versions);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager gitHubTokenName(String gitHubTokenName) {
        this.config().setGitHubTokenName(gitHubTokenName);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager gitHubTokenSecret(String gitHubTokenSecret) {
        this.config().setGitHubTokenSecret(gitHubTokenSecret);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager timeout(int timeout) {
        this.config().setTimeout(timeout);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager properties(String properties) {
        this.config().setProperties(properties);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager targetPath(String targetPath) {
        this.config().setTargetPath(targetPath);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidExport() {
        this.config().setAvoidExport(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidOutputTree() {
        this.config().setAvoidOutputTree(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidAutoVersion() {
        this.config().setAvoidAutoVersion(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidPreferences() {
        this.config().setAvoidPreferences(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager ttl(int seconds) {
        this.config().setTtl(seconds);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager browserPath(String browserPath) {
        this.config().setBinaryPath(browserPath);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public String getBinaryPath() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).binaryPath;
    }

    public String getDownloadedVersion() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).downloadedVersion;
    }

    public List<String> getVersions() {
        this.httpClient = new HttpClient(this.config());
        try {
            List<URL> drivers = this.getDrivers();
            ArrayList<String> versions = new ArrayList<String>();
            for (URL url : drivers) {
                String version = this.getCurrentVersion(url, this.getDriverName());
                if (version.isEmpty() || version.equalsIgnoreCase("icons")) continue;
                if (version.startsWith(".")) {
                    version = version.substring(1);
                }
                if (versions.contains(version)) continue;
                versions.add(version);
            }
            log.trace("Version list before sorting {}", versions);
            Collections.sort(versions, new VersionComparator());
            return versions;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    public void clearPreferences() {
        WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).preferences.clear();
    }

    public void clearCache() {
        String targetPath = this.config().getTargetPath();
        try {
            log.debug("Clearing cache at {}", (Object)targetPath);
            FileUtils.deleteDirectory((File)new File(targetPath));
        }
        catch (Exception e) {
            log.warn("Exception deleting cache at {}", (Object)targetPath, (Object)e);
        }
    }

    protected String preDownload(String target, String version) {
        log.trace("Pre-download. target={}, version={}", (Object)target, (Object)version);
        return target;
    }

    protected File postDownload(File archive) {
        File[] ls;
        File parentFolder = archive.getParentFile();
        for (File f : ls = parentFolder.listFiles()) {
            if (!this.getDriverName().contains(FilenameUtils.removeExtension((String)f.getName()))) continue;
            log.trace("Found binary in post-download: {}", (Object)f);
            return f;
        }
        throw new WebDriverManagerException("Driver " + this.getDriverName() + " not found (using temporal folder " + parentFolder + ")");
    }

    protected String getCurrentVersion(URL url, String driverName) {
        String currentVersion = "";
        try {
            currentVersion = url.getFile().substring(url.getFile().indexOf(SLASH) + 1, url.getFile().lastIndexOf(SLASH));
        }
        catch (StringIndexOutOfBoundsException e) {
            log.trace("Exception getting version of URL {} ({})", (Object)url, (Object)e.getMessage());
        }
        return currentVersion;
    }

    protected void manage(Architecture arch, String version) {
        this.httpClient = new HttpClient(this.config());
        try (HttpClient wdmHttpClient = this.httpClient;){
            String versionStr;
            this.downloader = new Downloader(this.getDriverManagerType());
            this.urlFilter = new UrlFilter();
            boolean getLatest = this.isVersionLatest(version);
            boolean cache = this.config().isForceCache();
            if (getLatest) {
                version = this.detectDriverVersionFromBrowser();
            }
            if ((getLatest = Config.isNullOrEmpty(version)) && !this.config().isUseBetaVersions()) {
                Optional<String> lastVersion = this.getLatestVersion();
                boolean bl = getLatest = !lastVersion.isPresent();
                if (!getLatest) {
                    version = lastVersion.get();
                }
            }
            if (this.checkPreInstalledVersion(version)) {
                return;
            }
            String os = this.config().getOs();
            log.trace("Managing {} arch={} version={} getLatest={} cache={}", new Object[]{this.getDriverName(), arch, version, getLatest, cache});
            if (getLatest && this.latestVersion != null) {
                log.debug("Latest version of {} is {} (recently resolved)", (Object)this.getDriverName(), (Object)this.latestVersion);
                version = this.latestVersion;
                cache = true;
            }
            Optional<String> driverInCache = this.handleCache(arch, version, os, getLatest, cache);
            String string = versionStr = getLatest ? "(latest version)" : version;
            if (driverInCache.isPresent() && !this.config().isOverride()) {
                this.storeVersionToDownload(version);
                this.downloadedVersion = version;
                log.debug("Driver {} {} found in cache", (Object)this.getDriverName(), (Object)versionStr);
                this.exportDriver(driverInCache.get());
            } else {
                List<URL> candidateUrls = this.filterCandidateUrls(arch, version, getLatest);
                if (candidateUrls.isEmpty()) {
                    String errorMessage = this.getDriverName() + " " + versionStr + " for " + os + arch.toString() + " not found in " + this.getDriverUrl();
                    log.error(errorMessage);
                    throw new WebDriverManagerException(errorMessage);
                }
                this.downloadCandidateUrls(candidateUrls);
            }
        }
        catch (Exception e) {
            this.handleException(e, arch, version);
        }
    }

    private String detectDriverVersionFromBrowser() {
        String version = "";
        if (this.config().isAvoidAutoVersion()) {
            return version;
        }
        Optional<String> optionalBrowserVersion = this.getBrowserVersion();
        if (optionalBrowserVersion.isPresent()) {
            String browserVersion = optionalBrowserVersion.get();
            log.trace("Detected {} version {}", (Object)this.getDriverManagerType(), (Object)browserVersion);
            this.preferenceKey = this.getDriverManagerType().name().toLowerCase() + browserVersion;
            version = this.usePreferences() && this.preferences.checkKeyInPreferences(this.preferenceKey) ? this.preferences.getValueFromPreferences(this.preferenceKey) : this.getVersionForInstalledBrowser(browserVersion);
            if (!Config.isNullOrEmpty(version)) {
                log.info("Using {} {} (since {} {} is installed in your machine)", new Object[]{this.getDriverName(), version, this.getDriverManagerType(), browserVersion});
            }
        } else {
            log.debug("The proper {} version for your {} is unknown ... trying with the latest", (Object)this.getDriverName(), (Object)this.getDriverManagerType());
        }
        return version;
    }

    private boolean usePreferences() {
        boolean usePrefs = !this.config().isAvoidPreferences() && !this.config().isOverride() && !this.forcedArch && !this.forcedOs;
        log.trace("Using preferences {}", (Object)usePrefs);
        return usePrefs;
    }

    private boolean checkPreInstalledVersion(String version) {
        if (version.equals(PRE_INSTALLED)) {
            String systemRoot = System.getenv("SystemRoot");
            File microsoftWebDriverFile = new File(systemRoot, "System32" + File.separator + "MicrosoftWebDriver.exe");
            if (microsoftWebDriverFile.exists()) {
                this.downloadedVersion = PRE_INSTALLED;
                this.exportDriver(microsoftWebDriverFile.toString());
                return true;
            }
            this.retry = false;
            throw new WebDriverManagerException("MicrosoftWebDriver.exe should be pre-installed in an elevated command prompt executing: dism /Online /Add-Capability /CapabilityName:Microsoft.WebDriver~~~~0.0.1.0");
        }
        return false;
    }

    private boolean isVersionLatest(String version) {
        return Config.isNullOrEmpty(version) || version.equalsIgnoreCase("latest");
    }

    private String getVersionForInstalledBrowser(String browserVersion) {
        String driverVersion = "";
        DriverManagerType driverManagerType = this.getDriverManagerType();
        String driverLowerCase = driverManagerType.name().toLowerCase();
        Optional<String> driverVersionForBrowser = this.getDriverVersionForBrowserFromProperties(driverLowerCase + browserVersion, false);
        if (driverVersionForBrowser.isPresent()) {
            driverVersion = driverVersionForBrowser.get();
        } else {
            log.debug("The driver version for {} {} is unknown ... trying with latest", (Object)driverManagerType, (Object)browserVersion);
        }
        return driverVersion;
    }

    private Optional<String> getDriverVersionForBrowserFromProperties(String key, boolean online) {
        String onlineMessage = online ? ONLINE : LOCAL;
        log.trace("Getting driver version from {} properties for {}", (Object)onlineMessage, (Object)key);
        String value = this.getVersionFromProperties(online).getProperty(key);
        if (value == null) {
            String notOnlineMessage = online ? LOCAL : ONLINE;
            log.debug("Driver for {} not found in {} properties (using {} version)", new Object[]{key, onlineMessage, notOnlineMessage});
            this.versionsProperties = null;
            value = this.getVersionFromProperties(!online).getProperty(key);
        }
        return value == null ? Optional.empty() : Optional.of(value);
    }

    private Properties getVersionFromProperties(boolean online) {
        if (this.versionsProperties != null) {
            log.trace("Already created versions.properties");
            return this.versionsProperties;
        }
        try {
            InputStream inputStream = this.getVersionsInputStream(online);
            this.versionsProperties = new Properties();
            this.versionsProperties.load(inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            this.versionsProperties = null;
            throw new IllegalStateException("Cannot read versions.properties", e);
        }
        return this.versionsProperties;
    }

    private InputStream getVersionsInputStream(boolean online) throws IOException {
        InputStream inputStream;
        String onlineMessage = online ? ONLINE : LOCAL;
        log.trace("Reading {} version.properties to find out driver version", (Object)onlineMessage);
        try {
            inputStream = online ? this.getOnlineVersionsInputStream() : this.getLocalVersionsInputStream();
        }
        catch (Exception e) {
            String exceptionMessage = online ? LOCAL : ONLINE;
            log.warn("Error reading version.properties, using {} instead", (Object)exceptionMessage);
            inputStream = online ? this.getLocalVersionsInputStream() : this.getOnlineVersionsInputStream();
        }
        return inputStream;
    }

    private InputStream getLocalVersionsInputStream() {
        InputStream inputStream = Config.class.getResourceAsStream("/versions.properties");
        return inputStream;
    }

    private InputStream getOnlineVersionsInputStream() throws IOException {
        return this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(this.config().getVersionsPropertiesUrl())).getEntity().getContent();
    }

    protected void handleException(Exception e, Architecture arch, String version) {
        String versionStr = Config.isNullOrEmpty(version) ? "(latest version)" : version;
        String errorMessage = String.format("There was an error managing %s %s (%s)", this.getDriverName(), versionStr, e.getMessage());
        if (this.config().isForceCache() || !this.retry) {
            log.error("{}", (Object)errorMessage, (Object)e);
            throw new WebDriverManagerException(e);
        }
        this.config().setForceCache(true);
        this.config().setUseMirror(true);
        this.retry = false;
        log.warn("{} ... trying again using cache and mirror", (Object)errorMessage);
        this.manage(arch, version);
    }

    protected void downloadCandidateUrls(List<URL> candidateUrls) throws IOException, InterruptedException {
        URL url = candidateUrls.iterator().next();
        String exportValue = this.downloader.download(url, this.versionToDownload, this.getDriverName());
        this.exportDriver(exportValue);
        this.downloadedVersion = this.versionToDownload;
    }

    protected List<URL> filterCandidateUrls(Architecture arch, String version, boolean getLatest) throws IOException {
        List<URL> candidateUrls;
        boolean continueSearchingVersion;
        List<URL> urls = this.getDrivers();
        log.trace("All URLs: {}", urls);
        do {
            candidateUrls = getLatest ? this.checkLatest(urls, this.getDriverName()) : this.getVersion(urls, this.getDriverName(), version);
            log.trace("Candidate URLs: {}", candidateUrls);
            if (this.versionToDownload == null || this.getClass().equals(EdgeDriverManager.class)) break;
            if (!this.getDriverName().equalsIgnoreCase("IEDriverServer") && !this.getDriverName().equalsIgnoreCase("selenium-server-standalone")) {
                candidateUrls = this.urlFilter.filterByOs(candidateUrls, this.config().getOs());
            }
            candidateUrls = this.urlFilter.filterByArch(candidateUrls, arch, this.forcedArch);
            candidateUrls = this.filterByDistro(candidateUrls);
            boolean bl = continueSearchingVersion = (candidateUrls = this.filterByIgnoredVersions(candidateUrls)).isEmpty() && getLatest;
            if (!continueSearchingVersion) continue;
            log.info("No binary found for {} {} ... seeking another version", (Object)this.getDriverName(), (Object)this.versionToDownload);
            urls = this.removeFromList(urls, this.versionToDownload);
            this.versionToDownload = null;
        } while (continueSearchingVersion);
        return candidateUrls;
    }

    protected List<URL> filterByIgnoredVersions(List<URL> candidateUrls) {
        if (this.config().getIgnoreVersions() != null && !candidateUrls.isEmpty()) {
            candidateUrls = this.urlFilter.filterByIgnoredVersions(candidateUrls, this.config().getIgnoreVersions());
        }
        return candidateUrls;
    }

    protected List<URL> filterByDistro(List<URL> candidateUrls) throws IOException {
        if (this.config().getOs().equalsIgnoreCase("linux") && this.getDriverName().contains("phantomjs")) {
            candidateUrls = this.urlFilter.filterByDistro(candidateUrls, "2.5.0");
        }
        return candidateUrls;
    }

    protected Optional<String> handleCache(Architecture arch, String version, String os, boolean getLatest, boolean cache) {
        Optional<String> driverInCache = Optional.empty();
        if (cache || !getLatest) {
            driverInCache = this.getDriverFromCache(version, arch, os);
        }
        this.storeVersionToDownload(version);
        return driverInCache;
    }

    protected Optional<String> getDriverFromCache(String driverVersion, Architecture arch, String os) {
        log.trace("Checking if {} exists in cache", (Object)this.getDriverName());
        List<File> filesInCache = this.getFilesInCache();
        if (!filesInCache.isEmpty()) {
            filesInCache = this.filterCacheBy(filesInCache, this.getDriverName());
            filesInCache = this.filterCacheBy(filesInCache, driverVersion);
            if (!this.getDriverName().equals("msedgedriver")) {
                filesInCache = this.filterCacheBy(filesInCache, os.toLowerCase());
            }
            if (filesInCache.size() == 1) {
                return Optional.of(filesInCache.get(0).toString());
            }
            if (!(filesInCache = this.filterCacheBy(filesInCache, arch.toString())).isEmpty()) {
                return Optional.of(filesInCache.get(filesInCache.size() - 1).toString());
            }
        }
        log.trace("{} not found in cache", (Object)this.getDriverName());
        return Optional.empty();
    }

    protected List<File> filterCacheBy(List<File> input, String key) {
        ArrayList<File> output = new ArrayList<File>(input);
        if (!key.isEmpty() && !input.isEmpty()) {
            for (File f : input) {
                if (f.toString().contains(key)) continue;
                output.remove(f);
            }
        }
        log.trace("Filter cache by {} -- input list {} -- output list {} ", new Object[]{key, input, output});
        return output;
    }

    protected List<File> getFilesInCache() {
        return (List)FileUtils.listFiles((File)new File(this.downloader.getTargetPath()), null, (boolean)true);
    }

    protected List<URL> removeFromList(List<URL> list, String version) {
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version)) continue;
            out.remove(url);
        }
        return out;
    }

    protected List<URL> getVersion(List<URL> list, String driver, String version) {
        int i;
        ArrayList<URL> out = new ArrayList<URL>();
        if (this.getDriverName().contains("msedgedriver") && (i = this.listVersions.indexOf(version)) != -1) {
            out.add(list.get(i));
        }
        for (URL url : list) {
            if (!url.getFile().contains(driver) || !url.getFile().contains(version) || url.getFile().contains("-symbols")) continue;
            out.add(url);
        }
        if (this.versionToDownload != null && !this.versionToDownload.equals(version)) {
            this.versionToDownload = version;
            log.info("Using {} {}", (Object)driver, (Object)version);
        }
        return out;
    }

    protected List<URL> checkLatest(List<URL> list, String driver) {
        log.trace("Checking the lastest version of {} with URL list {}", (Object)driver, list);
        ArrayList<URL> out = new ArrayList<URL>();
        ArrayList<URL> copyOfList = new ArrayList<URL>(list);
        for (URL url : copyOfList) {
            try {
                this.handleDriver(url, driver, out);
            }
            catch (Exception e) {
                log.trace("There was a problem with URL {} : {}", (Object)url, (Object)e.getMessage());
                list.remove(url);
            }
        }
        this.storeVersionToDownload(this.versionToDownload);
        this.latestVersion = this.versionToDownload;
        log.info("Latest version of {} is {}", (Object)driver, (Object)this.versionToDownload);
        return out;
    }

    protected void handleDriver(URL url, String driver, List<URL> out) {
        if (!this.config().isUseBetaVersions() && url.getFile().toLowerCase().contains(BETA)) {
            return;
        }
        if (url.getFile().contains(driver)) {
            String currentVersion = this.getCurrentVersion(url, driver);
            if (currentVersion.equalsIgnoreCase(driver)) {
                return;
            }
            if (this.versionToDownload == null) {
                this.versionToDownload = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                this.versionToDownload = currentVersion;
                out.clear();
            }
            if (url.getFile().contains(this.versionToDownload)) {
                out.add(url);
            }
        }
    }

    protected boolean isUsingTaobaoMirror() {
        return this.getDriverUrl().getHost().equalsIgnoreCase("npm.taobao.org");
    }

    protected Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.replaceAll("v", "").split("\\.");
        String[] vals2 = str2.replaceAll("v", "").split("\\.");
        if (vals1[0].equals("")) {
            vals1[0] = "0";
        }
        if (vals2[0].equals("")) {
            vals2[0] = "0";
        }
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.signum(Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i])));
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (this.mirrorLog) {
            log.info("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverUrlContent = driverUrl.getPath();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (InputStream in = response.getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("href");
                if (link.contains("mirror") && link.endsWith(SLASH)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(driverStr + link.replace(driverUrlContent, ""))));
                    continue;
                }
                if (!link.startsWith(driverUrlContent) || link.contains("icons")) continue;
                urlList.add(new URL(driverStr + link.replace(driverUrlContent, "")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected List<URL> getDriversFromXml(URL driverUrl) throws IOException {
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
        ArrayList<URL> urls = new ArrayList<URL>();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            org.w3c.dom.Document xml = this.loadXML(reader);
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl.toURI().resolve(".") + e.getChildNodes().item(0).getNodeValue()));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }

    protected org.w3c.dom.Document loadXML(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    protected void exportDriver(String variableValue) {
        this.binaryPath = variableValue;
        Optional<String> exportParameter = this.getExportParameter();
        if (!this.config.isAvoidExport() && exportParameter.isPresent()) {
            String variableName = exportParameter.get();
            log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
            System.setProperty(variableName, variableValue);
        } else {
            log.info("Resulting binary {}", (Object)variableValue);
        }
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.httpClient.createHttpGet(driverUrl);
        String gitHubTokenName = this.config().getGitHubTokenName();
        String gitHubTokenSecret = this.config().getGitHubTokenSecret();
        if (!Config.isNullOrEmpty(gitHubTokenName) && !Config.isNullOrEmpty(gitHubTokenSecret)) {
            String userpass = gitHubTokenName + ":" + gitHubTokenSecret;
            String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
            get.addHeader("Authorization", basicAuth);
        }
        return this.httpClient.execute((HttpRequestBase)get).getEntity().getContent();
    }

    protected List<URL> getDriversFromGitHub() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
        if (this.isUsingTaobaoMirror()) {
            urls = this.getDriversFromMirror(driverUrl);
        } else {
            String driverVersion = this.versionToDownload;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                if (driverVersion != null) {
                    releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
                }
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            log.trace("Get version {} of {}", (Object)version, (Object)release);
            if ((release.getName() == null || !release.getName().contains(version)) && (release.getTagName() == null || !release.getTagName().contains(version))) continue;
            out = release;
            break;
        }
        return out;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected FilenameFilter getFolderFilter() {
        return (dir, name) -> dir.isDirectory() && name.toLowerCase().contains(this.getDriverName());
    }

    protected Optional<String> getDefaultBrowserVersion(String programFilesEnv, String winBrowserName, String linuxBrowserName, String macBrowserName, String versionFlag, String browserNameInOutput) {
        String browserPath;
        String browserVersionOutput;
        String browserBinaryPath = this.config().getBinaryPath();
        if (SystemUtils.IS_OS_WINDOWS) {
            String browserVersionOutput2 = this.getBrowserVersionInWindows(programFilesEnv, winBrowserName, browserBinaryPath);
            if (Config.isNullOrEmpty(browserVersionOutput2)) {
                browserVersionOutput2 = this.getBrowserVersionInWindows(this.getOtherProgramFilesEnv(), winBrowserName, browserBinaryPath);
            }
            if (!Config.isNullOrEmpty(browserVersionOutput2)) {
                return Optional.of(Shell.getVersionFromWmicOutput(browserVersionOutput2));
            }
        } else if ((SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) && !Config.isNullOrEmpty(browserVersionOutput = Shell.runAndWait(browserPath = !Config.isNullOrEmpty(browserBinaryPath) ? browserBinaryPath : (SystemUtils.IS_OS_LINUX ? linuxBrowserName : macBrowserName), versionFlag))) {
            return Optional.of(Shell.getVersionFromPosixOutput(browserVersionOutput, browserNameInOutput));
        }
        return Optional.empty();
    }

    private String getBrowserVersionInWindows(String programFilesEnv, String winBrowserName, String browserBinaryPath) {
        String programFiles = System.getenv(programFilesEnv).replaceAll("\\\\", "\\\\\\\\");
        String browserPath = Config.isNullOrEmpty(browserBinaryPath) ? programFiles + winBrowserName : browserBinaryPath;
        return Shell.runAndWait(this.getExecFile(), "wmic", "datafile", "where", "name='" + browserPath + "'", "get", "Version", "/value");
    }

    protected File getExecFile() {
        String systemRoot = System.getenv("SystemRoot");
        File system32 = new File(systemRoot, "System32");
        if (SystemUtils.IS_OS_WINDOWS && system32.exists() && system32.isDirectory()) {
            return system32;
        }
        return new File(".");
    }

    protected Optional<String> getLatestVersion() {
        return Optional.empty();
    }

    protected void reset() {
        this.config().reset();
        this.mirrorLog = false;
        this.listVersions = null;
        this.versionToDownload = null;
        this.forcedArch = false;
        this.forcedOs = false;
        this.retry = true;
        this.isLatest = true;
    }

    protected String getProgramFilesEnv() {
        return System.getProperty("os.arch").contains("64") ? "PROGRAMFILES(X86)" : "PROGRAMFILES";
    }

    protected String getOtherProgramFilesEnv() {
        return System.getProperty("os.arch").contains("64") ? "PROGRAMFILES" : "PROGRAMFILES(X86)";
    }

    protected URL getDriverUrlCkeckingMirror(URL url) {
        Optional<URL> mirrorUrl;
        if (this.config().isUseMirror() && (mirrorUrl = this.getMirrorUrl()).isPresent()) {
            return mirrorUrl.get();
        }
        return url;
    }

    public static void main(String[] args) {
        String validBrowsers = "chrome|firefox|opera|edge|phantomjs|iexplorer|selenium_server_standalone";
        if (args.length <= 0) {
            WebDriverManager.logCliError(validBrowsers);
        } else {
            String arg = args[0];
            if (arg.equalsIgnoreCase("server")) {
                WebDriverManager.startServer(args);
            } else if (arg.equalsIgnoreCase("clear-preferences")) {
                new Preferences(new Config()).clear();
            } else {
                WebDriverManager.resolveLocal(validBrowsers, arg);
            }
        }
    }

    private static void resolveLocal(String validBrowsers, String arg) {
        log.info("Using WebDriverManager to resolve {}", (Object)arg);
        try {
            DriverManagerType driverManagerType = DriverManagerType.valueOf(arg.toUpperCase());
            WebDriverManager wdm = WebDriverManager.getInstance(driverManagerType).avoidExport().targetPath(".").avoidAutoVersion().forceDownload();
            if (arg.equalsIgnoreCase("edge") || arg.equalsIgnoreCase("iexplorer")) {
                wdm.operatingSystem(OperatingSystem.WIN);
            }
            wdm.avoidOutputTree().setup();
        }
        catch (Exception e) {
            log.error("Driver for {} not found (valid browsers {})", (Object)arg, (Object)validBrowsers);
        }
    }

    private static void startServer(String[] args) {
        int port = new Config().getServerPort();
        if (args.length > 1 && StringUtils.isNumeric((CharSequence)args[1])) {
            port = Integer.parseInt(args[1]);
        }
        new Server(port);
    }

    private static void logCliError(String validBrowsers) {
        log.error("There are 3 options to run WebDriverManager CLI");
        log.error("1. WebDriverManager used to resolve binary drivers locally:");
        log.error("\tWebDriverManager browserName");
        log.error("\t(where browserName={})", (Object)validBrowsers);
        log.error("2. WebDriverManager as a server:");
        log.error("\tWebDriverManager server <port>");
        log.error("\t(where default port is 4041)");
        log.error("3. To clear previously resolved driver versions (as Java preferences):");
        log.error("\tWebDriverManager clear-preferences");
    }

    private void storeVersionToDownload(String version) {
        if (!Config.isNullOrEmpty(version)) {
            if (version.startsWith(".")) {
                version = version.substring(1);
            }
            this.versionToDownload = version;
            if (this.isLatest && this.usePreferences() && !Config.isNullOrEmpty(this.preferenceKey)) {
                this.preferences.putValueInPreferencesIfEmpty(this.preferenceKey, version);
            }
        }
    }

    private void setConfig(Config config) {
        this.config = config;
    }
}

