/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.cache;

import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Config config;

    public CacheHandler(Config config) {
        this.config = config;
        File cacheFolder = new File(config.getCachePath());
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
    }

    public List<File> filterCacheBy(List<File> input, String key, boolean isVersion) {
        String pathSeparator = isVersion ? File.separator : "";
        List<File> output = new ArrayList<File>(input);
        if (!key.isEmpty() && !input.isEmpty()) {
            output = input.stream().filter(file -> file.toString().toLowerCase(Locale.ROOT).contains(pathSeparator + key.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        this.log.trace("Filter cache by {} -- input list {} -- output list {} ", new Object[]{key, input, output});
        return output;
    }

    public List<File> getFilesInCache() {
        List listFiles = (List)FileUtils.listFiles((File)new File(this.config.getCachePath()), null, (boolean)true);
        Collections.sort(listFiles);
        return listFiles;
    }

    public Optional<String> getDriverFromCache(String driverVersion, String driverName, DriverManagerType driverManagerType, Architecture arch, String os) {
        this.log.trace("Checking if {} exists in cache", (Object)driverName);
        List<File> filesInCache = this.getFilesInCache();
        if (!filesInCache.isEmpty()) {
            filesInCache = this.filterCacheBy(filesInCache, driverName, false);
            filesInCache = this.filterCacheBy(filesInCache, driverVersion, true);
            if ((filesInCache = this.filterCacheBy(filesInCache, os, false)).size() == 1) {
                return Optional.of(filesInCache.get(0).toString());
            }
            if (os.equalsIgnoreCase("win") && (driverManagerType == DriverManagerType.CHROME || driverManagerType == DriverManagerType.CHROMIUM)) {
                this.log.trace("Avoid filtering for architecture {} with {} in Windows", (Object)arch, (Object)driverName);
            } else {
                filesInCache = this.filterCacheBy(filesInCache, arch.toString(), false);
            }
            if (!filesInCache.isEmpty()) {
                return Optional.of(filesInCache.get(filesInCache.size() - 1).toString());
            }
        }
        this.log.trace("{} not found in cache", (Object)driverName);
        return Optional.empty();
    }
}

