/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.cache;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionCache {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String TTL = "-ttl";
    static final String RESOLUTION_CACHE_INFO = "WebDriverManager Resolution Cache";
    Properties props = new Properties(){
        private static final long serialVersionUID = 3734950329657085291L;

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    };
    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM/yyyy z");
    Config config;
    File resolutionCacheFile;

    public ResolutionCache(Config config) {
        this.config = config;
        if (!config.isAvoidingResolutionCache()) {
            String resolutionCachePath = config.getResolutionCachePath();
            File cacheFolder = new File(resolutionCachePath);
            if (!cacheFolder.exists()) {
                cacheFolder.mkdirs();
            }
            this.resolutionCacheFile = new File(resolutionCachePath, config.getResolutionCache());
            try {
                boolean createNewFile;
                if (!this.resolutionCacheFile.exists() && (createNewFile = this.resolutionCacheFile.createNewFile())) {
                    this.log.debug("Created new resolution cache file at {}", (Object)this.resolutionCacheFile);
                }
                try (FileInputStream fis = new FileInputStream(this.resolutionCacheFile);){
                    this.props.load(fis);
                }
            }
            catch (Exception e) {
                throw new WebDriverManagerException("Exception reading resolution cache as a properties file", e);
            }
        }
    }

    public String getValueFromResolutionCache(String key) {
        return this.props.getProperty(key, null);
    }

    private Date getExpirationDateFromResolutionCache(String key) {
        Date result = new Date(0L);
        try {
            result = this.dateFormat.parse(this.props.getProperty(this.getExpirationKey(key)));
            return result;
        }
        catch (Exception e) {
            this.log.warn("Exception parsing date ({}) from resolution cache {}", (Object)key, (Object)e.getMessage());
            return result;
        }
    }

    public void putValueInResolutionCacheIfEmpty(String key, String value, int ttl) {
        if (ttl > 0 && this.getValueFromResolutionCache(key) == null) {
            this.props.put(key, value);
            long now = new Date().getTime();
            Date expirationDate = new Date(now + TimeUnit.SECONDS.toMillis(ttl));
            String expirationDateStr = this.formatDate(expirationDate);
            this.props.put(this.getExpirationKey(key), expirationDateStr);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing resolution {}={} in cache (valid until {})", new Object[]{key, value, expirationDateStr});
            }
            this.storeProperties();
        }
    }

    private synchronized void storeProperties() {
        try (FileOutputStream fos = new FileOutputStream(this.resolutionCacheFile);){
            this.props.store(fos, RESOLUTION_CACHE_INFO);
        }
        catch (Exception e) {
            this.log.warn("Exception writing resolution cache as a properties file {}", (Object)e.getClass().getName());
        }
    }

    private void clearFromResolutionCache(String key) {
        this.props.remove(key);
        this.props.remove(this.getExpirationKey(key));
        this.storeProperties();
    }

    public void clear() {
        this.log.info("Clearing WebDriverManager resolution cache");
        this.props.clear();
        this.storeProperties();
    }

    private boolean checkValidity(String key, String value, Date expirationDate) {
        boolean isValid;
        long now = new Date().getTime();
        long expirationTime = expirationDate != null ? expirationDate.getTime() : 0L;
        boolean bl = isValid = value != null && expirationTime != 0L && expirationTime > now;
        if (!isValid) {
            this.log.debug("Removing resolution {}={} from cache (expired on {})", new Object[]{key, value, expirationDate});
            this.clearFromResolutionCache(key);
        }
        return isValid;
    }

    private String formatDate(Date date) {
        return date != null ? this.dateFormat.format(date) : "";
    }

    private String getExpirationKey(String key) {
        return key + TTL;
    }

    public boolean checkKeyInResolutionCache(String key) {
        return this.checkKeyInResolutionCache(key, true);
    }

    public boolean checkKeyInResolutionCache(String key, boolean showLog) {
        Date expirationDate;
        boolean valueInResolutionCache;
        String valueFromResolutionCache = this.getValueFromResolutionCache(key);
        boolean bl = valueInResolutionCache = valueFromResolutionCache != null && !valueFromResolutionCache.isEmpty();
        if (valueInResolutionCache && (valueInResolutionCache &= this.checkValidity(key, valueFromResolutionCache, expirationDate = this.getExpirationDateFromResolutionCache(key)))) {
            String strDate = this.formatDate(expirationDate);
            if (showLog) {
                this.log.debug("Resolution {}={} in cache (valid until {})", new Object[]{key, valueFromResolutionCache, strDate});
            }
        }
        return valueInResolutionCache;
    }
}

