/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotEnvException;
import io.github.cdimascio.dotenv.internal.DotenvParser;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00130\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/cdimascio/dotenv/internal/DotenvParser;", "", "reader", "Lio/github/cdimascio/dotenv/internal/DotenvReader;", "throwIfMalformed", "", "throwIfMissing", "(Lio/github/cdimascio/dotenv/internal/DotenvReader;ZZ)V", "isComment", "Lkotlin/Function1;", "", "isQuoted", "isWhiteSpace", "parseLine", "Lkotlin/text/MatchResult;", "normalizeValue", "value", "parse", "", "Lkotlin/Pair;", "java-dotenv"})
public final class DotenvParser {
    private final Function1<String, Boolean> isWhiteSpace;
    private final Function1<String, Boolean> isComment;
    private final Function1<String, MatchResult> parseLine;
    private final Function1<String, Boolean> isQuoted;
    private final DotenvReader reader;
    private final boolean throwIfMalformed;
    private final boolean throwIfMissing;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, String>> parse() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        List lines;
        Stream<String> stream;
        try {
            stream = this.reader.read();
        }
        catch (DotEnvException e) {
            if (this.throwIfMissing) {
                throw (Throwable)e;
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        List list = lines = stream.collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"lines");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var11_15;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            boolean bl2 = false;
            void v1 = var11_15;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
            collection.add(string);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)this.isWhiteSpace.invoke((Object)it) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)this.isComment.invoke((Object)it) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl3 = false;
            MatchResult match = (MatchResult)this.parseLine.invoke((Object)it2);
            if (match != null) {
                void key;
                MatchResult.Destructured destructured;
                MatchResult.Destructured destructured2 = destructured = match.getDestructured();
                boolean bl4 = false;
                String string = (String)destructured2.getMatch().getGroupValues().get(1);
                destructured2 = destructured;
                bl4 = false;
                String value = (String)destructured2.getMatch().getGroupValues().get(3);
                pair = new Pair((Object)key, (Object)this.normalizeValue(value));
            } else {
                if (this.throwIfMalformed) {
                    throw (Throwable)new DotEnvException("Malformed entry: " + it2);
                }
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl5 = false;
            boolean bl6 = false;
            Pair it$iv$iv = pair2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String normalizeValue(String value) {
        String string = value;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String tr = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return (Boolean)this.isQuoted.invoke((Object)tr) != false ? StringsKt.substring((String)tr, (IntRange)RangesKt.until((int)1, (int)(value.length() - 1))) : tr;
    }

    public DotenvParser(@NotNull DotenvReader reader, boolean throwIfMalformed, boolean throwIfMissing) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.reader = reader;
        this.throwIfMalformed = throwIfMalformed;
        this.throwIfMissing = throwIfMissing;
        this.isWhiteSpace = isWhiteSpace.1.INSTANCE;
        this.isComment = isComment.1.INSTANCE;
        this.parseLine = parseLine.1.INSTANCE;
        this.isQuoted = isQuoted.1.INSTANCE;
    }
}

