/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.consul;

import org.lognet.springboot.grpc.GRpcServerRunner;
import org.lognet.springboot.grpc.autoconfigure.GRpcAutoConfiguration;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.autoconfigure.OnGrpcServerEnabled;
import org.lognet.springboot.grpc.autoconfigure.consul.GrpcConsulRegistrar;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ConsulServiceRegistry.class})
@AutoConfigureAfter(value={ConsulServiceRegistryAutoConfiguration.class, GRpcAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={ConsulServiceRegistry.class, GRpcServerRunner.class})
@OnGrpcServerEnabled
public class ConsulGrpcAutoConfiguration {
    @Bean
    public ConfigurationPropertiesBindHandlerAdvisor advisor() {
        return b -> new AbstractBindHandler(b){
            private final ConfigurationPropertyName grpcConfigName;
            {
                this.grpcConfigName = ConfigurationPropertyName.of((CharSequence)"grpc");
            }

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                if (this.grpcConfigName.equals((Object)name)) {
                    ConsulDiscoveryProperties result = (ConsulDiscoveryProperties)context.getBinder().bindOrCreate("spring.cloud.consul.discovery", ConsulDiscoveryProperties.class);
                    GRpcServerProperties p = (GRpcServerProperties)target.getValue().get();
                    p.getConsul().setDiscovery(result);
                }
                return super.onStart(name, target, context);
            }
        };
    }

    @Bean
    public GrpcConsulRegistrar consulRegistrar(ConsulServiceRegistry consulServiceRegistry) {
        return new GrpcConsulRegistrar(consulServiceRegistry);
    }
}

