/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.introspect.support;

import io.hawt.introspect.ClassLoaderProvider;
import io.hawt.introspect.support.CacheValue;
import io.hawt.introspect.support.ClassResource;
import io.hawt.introspect.support.Packages;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassScanner {
    private static final transient Logger LOG = LoggerFactory.getLogger(ClassScanner.class);
    private final ClassLoader[] classLoaders;
    private WeakHashMap<String, CacheValue> cache = new WeakHashMap();
    private WeakHashMap<Package, CacheValue> packageCache = new WeakHashMap();
    private Map<String, ClassLoaderProvider> classLoaderProviderMap = new HashMap<String, ClassLoaderProvider>();

    public static ClassScanner newInstance() {
        return new ClassScanner(Thread.currentThread().getContextClassLoader(), ClassScanner.class.getClassLoader());
    }

    public ClassScanner(ClassLoader ... classLoaders) {
        this.classLoaders = classLoaders;
    }

    public void setClassLoaderProvider(String id, ClassLoaderProvider classLoaderProvider) {
        if (classLoaderProvider != null) {
            this.classLoaderProviderMap.put(id, classLoaderProvider);
        } else {
            this.classLoaderProviderMap.remove(id);
        }
    }

    public SortedSet<String> findClassNames(String search, Integer limit) {
        Map<Package, ClassLoader[]> packageMap = Packages.getPackageMap(this.getClassLoaders());
        return this.findClassNamesInPackages(search, limit, packageMap);
    }

    public SortedSet<String> findClassNamesInPackages(String search, Integer limit, Map<Package, ClassLoader[]> packages) {
        TreeSet<String> answer = new TreeSet<String>();
        TreeSet<String> classes = new TreeSet<String>();
        Set<Map.Entry<Package, ClassLoader[]>> entries = packages.entrySet();
        for (Map.Entry<Package, ClassLoader[]> entry : entries) {
            Package aPackage = entry.getKey();
            ClassLoader[] classLoaders = entry.getValue();
            CacheValue cacheValue = this.packageCache.get(aPackage);
            if (cacheValue == null) {
                cacheValue = this.createPackageCacheValue(aPackage, classLoaders);
                this.packageCache.put(aPackage, cacheValue);
            }
            classes.addAll(cacheValue.getClassNames());
        }
        if (this.withinLimit(limit, answer)) {
            for (String aClass : classes) {
                if (!this.classNameMatches(aClass, search)) continue;
                answer.add(aClass);
                if (this.withinLimit(limit, answer)) continue;
                break;
            }
        }
        return answer;
    }

    public SortedMap<String, Class<?>> getAllClassesMap() {
        Package[] packages = Package.getPackages();
        return this.getClassesMap(packages);
    }

    public SortedMap<String, Class<?>> getClassesMap(Package ... packages) {
        TreeMap answer = new TreeMap();
        HashMap<String, ClassResource> urlSet = new HashMap<String, ClassResource>();
        for (Package aPackage : packages) {
            this.addPackageResources(aPackage, urlSet, this.classLoaders);
        }
        for (ClassResource classResource : urlSet.values()) {
            Set<Class<?>> classes = this.getClassesForPackage(classResource, null, null);
            for (Class<?> aClass : classes) {
                answer.put(aClass.getName(), aClass);
            }
        }
        return answer;
    }

    public Set<Class<?>> getClassesForPackage(ClassResource classResource, String filter, Integer limit) {
        HashSet classes = new HashSet();
        this.addClassesForPackage(classResource, filter, limit, classes);
        return classes;
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return Class.forName(className);
    }

    protected void addPackageResources(Package aPackage, Map<String, ClassResource> urlSet, ClassLoader[] classLoaders) {
        String packageName = aPackage.getName();
        String relativePath = this.getPackageRelativePath(packageName);
        List<URL> resources = this.getResources(relativePath, classLoaders);
        for (URL resource : resources) {
            String key = this.getJavaResourceKey(resource);
            urlSet.put(key, new ClassResource(packageName, resource));
        }
    }

    private CacheValue createPackageCacheValue(Package aPackage, ClassLoader[] classLoaders) {
        HashMap<String, ClassResource> urlSet = new HashMap<String, ClassResource>();
        this.addPackageResources(aPackage, urlSet, classLoaders);
        CacheValue answer = new CacheValue();
        SortedSet<String> classNames = answer.getClassNames();
        Set entries = urlSet.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            ClassResource classResource = (ClassResource)entry.getValue();
            CacheValue cacheValue = this.cache.get(key);
            if (cacheValue == null) {
                cacheValue = this.createCacheValue(key, classResource);
                this.cache.put(key, cacheValue);
            }
            classNames.addAll(cacheValue.getClassNames());
        }
        return answer;
    }

    protected CacheValue createCacheValue(String key, ClassResource classResource) {
        CacheValue answer = new CacheValue();
        SortedSet<String> classNames = answer.getClassNames();
        String packageName = classResource.getPackageName();
        URL resource = classResource.getResource();
        if (resource != null) {
            String resourceText = resource.toString();
            LOG.debug("Searching resource " + resource);
            if (resourceText.startsWith("jar:")) {
                this.processJarClassNames(classResource, classNames);
            } else {
                this.processDirectoryClassNames(new File(resource.getPath()), packageName, classNames);
            }
        }
        return answer;
    }

    protected void processDirectoryClassNames(File directory, String packageName, Set<String> classes) {
        String[] fileNames = directory.list();
        if (fileNames != null) {
            for (String fileName : fileNames) {
                File subdir;
                String packagePrefix;
                String string = packagePrefix = Strings.isNotBlank(packageName) ? packageName + '.' : packageName;
                if (fileName.endsWith(".class")) {
                    String className = packagePrefix + fileName.substring(0, fileName.length() - 6);
                    classes.add(className);
                }
                if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
                this.processDirectoryClassNames(subdir, packagePrefix + fileName, classes);
            }
        }
    }

    protected void processJarClassNames(ClassResource classResource, Set<String> classes) {
        JarFile jarFile;
        URL resource = classResource.getResource();
        String packageName = classResource.getPackageName();
        String relativePath = this.getPackageRelativePath(packageName);
        String jarPath = this.getJarPath(resource);
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            LOG.debug("IOException reading JAR '" + jarPath + ". Reason: " + e, (Throwable)e);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class") || !entryName.startsWith(relativePath) || entryName.length() <= relativePath.length() + 1) continue;
            String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            classes.add(className);
        }
    }

    protected void addClassesForPackage(ClassResource classResource, String filter, Integer limit, Set<Class<?>> classes) {
        String packageName = classResource.getPackageName();
        URL resource = classResource.getResource();
        if (resource != null && this.withinLimit(limit, classes)) {
            String resourceText = resource.toString();
            LOG.debug("Searching resource " + resource);
            if (resourceText.startsWith("jar:")) {
                this.processJar(classResource, classes, filter, limit);
            } else {
                this.processDirectory(new File(resource.getPath()), packageName, classes, filter, limit);
            }
        }
    }

    protected void processDirectory(File directory, String packageName, Set<Class<?>> classes, String filter, Integer limit) {
        String[] fileNames = directory.list();
        if (fileNames != null) {
            for (String fileName : fileNames) {
                File subdir;
                Class<?> aClass;
                String packagePrefix;
                if (!this.withinLimit(limit, classes)) {
                    return;
                }
                String className = null;
                String string = packagePrefix = Strings.isNotBlank(packageName) ? packageName + '.' : packageName;
                if (fileName.endsWith(".class")) {
                    className = packagePrefix + fileName.substring(0, fileName.length() - 6);
                }
                if ((aClass = this.tryFindClass(className, filter)) != null) {
                    classes.add(aClass);
                }
                if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
                this.processDirectory(subdir, packagePrefix + fileName, classes, filter, limit);
            }
        }
    }

    protected void processJar(ClassResource classResource, Set<Class<?>> classes, String filter, Integer limit) {
        JarFile jarFile;
        URL resource = classResource.getResource();
        String packageName = classResource.getPackageName();
        String relativePath = this.getPackageRelativePath(packageName);
        String jarPath = this.getJarPath(resource);
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            LOG.debug("IOException reading JAR '" + jarPath + ". Reason: " + e, (Throwable)e);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && this.withinLimit(limit, classes)) {
            Class<?> aClass;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relativePath) && entryName.length() > relativePath.length() + 1) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            if ((aClass = this.tryFindClass(className, filter)) == null) continue;
            classes.add(aClass);
        }
    }

    protected String getJavaResourceKey(URL resource) {
        String resourceText = resource.toString();
        if (resourceText.startsWith("jar:")) {
            return "jar:" + this.getJarPath(resource);
        }
        return resource.getPath();
    }

    private String getJarPath(URL resource) {
        String resourcePath = resource.getPath();
        return resourcePath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
    }

    protected Class<?> tryFindClass(String className, String filter) {
        Class<?> aClass = null;
        if (Strings.isNotBlank(className) && this.classNameMatches(className, filter)) {
            try {
                aClass = this.findClass(className);
            }
            catch (Throwable e) {
                LOG.debug("Could not load class " + className + ". " + e, e);
            }
        }
        return aClass;
    }

    protected List<URL> getResources(String relPath, ClassLoader ... classLoaders) {
        ArrayList<URL> answer = new ArrayList<URL>();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> resources = classLoader.getResources(relPath);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (url == null) continue;
                    answer.add(url);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to load resources for path " + relPath + " from class loader " + classLoader + ". Reason:  " + e, (Throwable)e);
            }
            if (!(classLoader instanceof URLClassLoader)) continue;
            URLClassLoader loader = (URLClassLoader)classLoader;
            answer.addAll(Arrays.asList(loader.getURLs()));
        }
        return answer;
    }

    protected boolean classNameMatches(String className, String search) {
        return className.contains(search);
    }

    protected String getPackageRelativePath(String packageName) {
        return packageName.replace('.', '/');
    }

    protected boolean withinLimit(Integer limit, Collection<?> collection) {
        if (limit == null) {
            return true;
        }
        int value = limit;
        return value <= 0 || value > collection.size();
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> answer = new ArrayList<ClassLoader>();
        answer.addAll(Arrays.asList(this.classLoaders));
        Collection<ClassLoaderProvider> classLoaderProviders = this.classLoaderProviderMap.values();
        for (ClassLoaderProvider classLoaderProvider : classLoaderProviders) {
            ClassLoader classLoader = classLoaderProvider.getClassLoader();
            if (classLoader == null) continue;
            answer.add(classLoader);
        }
        return answer;
    }
}

