/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MBeanSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(MBeanSupport.class);
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private boolean registered;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName(this.getDefaultObjectName());
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (!this.registered && !this.mBeanServer.isRegistered(this.objectName)) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                LOG.warn("This mbean is already registered " + this.objectName + ". There must be multiple deployment units with this mbean inside.");
            }
            this.registered = true;
        }
    }

    public void destroy() throws Exception {
        if (this.registered && this.objectName != null && this.mBeanServer != null) {
            this.registered = false;
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    protected abstract String getDefaultObjectName();
}

