/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Context;
import io.jooby.Err;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.StatusCode;
import io.jooby.internal.netty.HttpRawPostRequestDecoder;
import io.jooby.internal.netty.NettyContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class NettyHandler
extends ChannelInboundHandlerAdapter {
    private final Router router;
    private final int bufferSize;
    private final Consumer<HttpHeaders> defaultHeaders;
    private NettyContext context;
    private Router.Match result;
    private final HttpDataFactory factory;
    private InterfaceHttpPostRequestDecoder decoder;
    private final long maxRequestSize;
    private long contentLength;
    private long chunkSize;

    public NettyHandler(Router router, long maxRequestSize, int bufferSize, HttpDataFactory factory, Consumer<HttpHeaders> defaultHeaders) {
        this.router = router;
        this.maxRequestSize = maxRequestSize;
        this.factory = factory;
        this.bufferSize = bufferSize;
        this.defaultHeaders = defaultHeaders;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            this.context = new NettyContext(ctx, req, this.router, NettyHandler.pathOnly(req.uri()), this.bufferSize);
            this.defaultHeaders.accept((HttpHeaders)this.context.setHeaders);
            this.result = this.router.match((Context)this.context);
            if (this.result.matches()) {
                this.contentLength = this.contentLength(req);
                boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)req);
                if (this.contentLength > 0L || chunked) {
                    this.decoder = this.newDecoder(req, this.factory);
                } else {
                    this.result.execute((Context)this.context);
                }
            } else {
                this.result.execute((Context)this.context);
            }
        } else if (this.decoder != null && msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            this.chunkSize += (long)chunk.content().readableBytes();
            if (this.chunkSize > this.maxRequestSize) {
                this.resetDecoderState(true);
                chunk.release();
                this.context.sendError((Throwable)new Err(StatusCode.REQUEST_ENTITY_TOO_LARGE));
                return;
            }
            this.offer(chunk);
            if (this.contentLength == this.chunkSize && !(chunk instanceof LastHttpContent)) {
                chunk = LastHttpContent.EMPTY_LAST_CONTENT;
                this.offer(chunk);
            }
            if (chunk instanceof LastHttpContent) {
                this.context.decoder = this.decoder;
                this.resetDecoderState(false);
                this.result.execute((Context)this.context);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.context != null) {
            this.context.flush();
        }
    }

    private long contentLength(HttpRequest req) {
        String value = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException x) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            Logger log = this.router.getLog();
            if (Server.connectionLost((Throwable)cause)) {
                if (log.isDebugEnabled()) {
                    if (this.context == null) {
                        log.debug("execution resulted in connection lost", cause);
                    } else {
                        log.debug("%s %s", new Object[]{this.context.getMethod(), this.context.pathString(), cause});
                    }
                }
            } else if (this.context == null) {
                log.error("execution resulted in exception", cause);
            } else {
                this.context.sendError(cause);
                this.context = null;
            }
        }
        finally {
            ctx.close();
        }
    }

    private void offer(HttpContent chunk) {
        try {
            this.decoder.offer(chunk);
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException x) {
            this.resetDecoderState(true);
            this.context.sendError(x, StatusCode.BAD_REQUEST);
        }
    }

    private void resetDecoderState(boolean destroy) {
        this.chunkSize = 0L;
        this.contentLength = -1L;
        if (destroy && this.decoder != null) {
            this.decoder.destroy();
        }
        this.decoder = null;
    }

    private InterfaceHttpPostRequestDecoder newDecoder(HttpRequest request, HttpDataFactory factory) {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            if (lowerContentType.startsWith("multipart/form-data")) {
                return new HttpPostMultipartRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
            if (lowerContentType.equals("application/x-www-form-urlencoded")) {
                return new HttpPostStandardRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
        }
        return new HttpRawPostRequestDecoder((HttpData)factory.createAttribute(request, "body"));
    }

    static String pathOnly(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c != '?') continue;
            return uri.substring(0, i);
        }
        return uri;
    }
}

