/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;

public class NettyOutputStream
extends OutputStream {
    private final ByteBuf buffer;
    private final ChannelHandlerContext ctx;
    private final ChannelFutureListener closeListener;
    private HttpResponse headers;

    public NettyOutputStream(ChannelHandlerContext ctx, int bufferSize, HttpResponse headers, ChannelFutureListener closeListener) {
        this.buffer = ctx.alloc().buffer(0, bufferSize);
        this.ctx = ctx;
        this.headers = headers;
        this.closeListener = closeListener;
    }

    @Override
    public void write(int b) {
        this.writeHeaders();
        if (this.buffer.maxWritableBytes() < 1) {
            this.flush(null, null);
        }
        this.buffer.writeByte(b);
    }

    @Override
    public void write(byte[] src, int off, int len) {
        this.write(src, off, len, null);
    }

    public void write(byte[] src, int off, int len, ChannelFutureListener callback) {
        int dataLengthLeftToWrite;
        int spaceLeftInCurrentChunk;
        this.writeHeaders();
        int dataToWriteOffset = off;
        for (dataLengthLeftToWrite = len; (spaceLeftInCurrentChunk = this.buffer.maxWritableBytes()) < dataLengthLeftToWrite; dataLengthLeftToWrite -= spaceLeftInCurrentChunk) {
            this.buffer.writeBytes(src, dataToWriteOffset, spaceLeftInCurrentChunk);
            dataToWriteOffset += spaceLeftInCurrentChunk;
            this.flush(callback, null);
        }
        if (dataLengthLeftToWrite > 0) {
            this.buffer.writeBytes(src, dataToWriteOffset, dataLengthLeftToWrite);
        }
    }

    private void writeHeaders() {
        if (this.headers != null) {
            this.ctx.write((Object)this.headers, this.ctx.voidPromise());
            this.headers = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(null, null);
    }

    private void flush(ChannelFutureListener callback, ChannelFutureListener listener) {
        int chunkSize = this.buffer.readableBytes();
        if (chunkSize > 0) {
            if (listener != null) {
                if (callback == null) {
                    this.ctx.write((Object)new DefaultHttpContent(this.buffer.copy()), this.ctx.voidPromise());
                } else {
                    this.ctx.write((Object)new DefaultHttpContent(this.buffer.copy())).addListener((GenericFutureListener)callback);
                }
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)listener);
                this.buffer.release();
            } else {
                if (callback == null) {
                    this.ctx.write((Object)new DefaultHttpContent(this.buffer.copy()), this.ctx.voidPromise());
                } else {
                    this.ctx.write((Object)new DefaultHttpContent(this.buffer.copy())).addListener((GenericFutureListener)callback);
                }
                this.buffer.clear();
            }
        } else {
            ChannelFuture future = this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (listener != null) {
                future.addListener((GenericFutureListener)listener);
            }
        }
    }

    @Override
    public void close() {
        this.flush(null, this.closeListener);
    }
}

