/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class HttpRawPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private HttpRequest request;
    private HttpDataFactory factory;
    private HttpData data;

    public HttpRawPostRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this.factory = factory;
        this.request = request;
        this.data = factory.createAttribute(request, "body");
    }

    public boolean isMultipart() {
        return false;
    }

    public void setDiscardThreshold(int discardThreshold) {
    }

    public int getDiscardThreshold() {
        return 0;
    }

    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.data == null ? Collections.emptyList() : Collections.singletonList(this.data);
    }

    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        return this.getBodyHttpDatas();
    }

    public InterfaceHttpData getBodyHttpData(String name) {
        return this.data;
    }

    public InterfaceHttpPostRequestDecoder offer(HttpContent content) {
        try {
            this.data.addContent(content.content().copy(), content instanceof LastHttpContent);
            return this;
        }
        catch (IOException x) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)x);
        }
    }

    public boolean hasNext() {
        return this.data != null;
    }

    public InterfaceHttpData next() {
        return this.data;
    }

    public InterfaceHttpData currentPartialHttpData() {
        return this.data;
    }

    public void destroy() {
        this.cleanFiles();
        this.removeHttpDataFromClean((InterfaceHttpData)this.data);
        this.data.delete();
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpData(this.request);
    }

    public void removeHttpDataFromClean(InterfaceHttpData data) {
        this.factory.removeHttpDataFromClean(this.request, data);
    }
}

