/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public abstract class NettyTransport {
    private static final int BACKLOG = 8192;

    public ServerBootstrap configure(EventLoopGroup acceptor, EventLoopGroup eventloop) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)8192);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        return bootstrap.group(acceptor, eventloop);
    }

    public abstract EventLoopGroup createEventLoop(int var1, String var2, int var3);

    public static NettyTransport transport(ClassLoader loader) {
        if (NettyTransport.isEpoll(loader)) {
            return NettyTransport.epoll();
        }
        if (NettyTransport.isKQueue(loader)) {
            return NettyTransport.kqueue();
        }
        return NettyTransport.nio();
    }

    private static NettyTransport kqueue() {
        return new KQueueTransport();
    }

    private static NettyTransport epoll() {
        return new EpollTransport();
    }

    private static boolean isEpoll(ClassLoader loader) {
        try {
            loader.loadClass("io.netty.channel.epoll.Epoll");
            return Epoll.isAvailable();
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    private static boolean isKQueue(ClassLoader loader) {
        try {
            loader.loadClass("io.netty.channel.kqueue.KQueue");
            return KQueue.isAvailable();
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    private static NettyTransport nio() {
        return new JDKTransport();
    }

    private static class KQueueTransport
    extends NettyTransport {
        private KQueueTransport() {
        }

        @Override
        public EventLoopGroup createEventLoop(int threads, String threadName, int ioRatio) {
            KQueueEventLoopGroup loopGroup = new KQueueEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory(threadName + "-kqueue"));
            loopGroup.setIoRatio(ioRatio);
            return loopGroup;
        }

        @Override
        public ServerBootstrap configure(EventLoopGroup acceptor, EventLoopGroup eventloop) {
            return (ServerBootstrap)super.configure(acceptor, eventloop).channel(KQueueServerSocketChannel.class);
        }
    }

    private static class EpollTransport
    extends NettyTransport {
        private EpollTransport() {
        }

        @Override
        public EventLoopGroup createEventLoop(int threads, String threadName, int ioRatio) {
            EpollEventLoopGroup loopGroup = new EpollEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory(threadName + "-epoll"));
            return loopGroup;
        }

        @Override
        public ServerBootstrap configure(EventLoopGroup acceptor, EventLoopGroup eventloop) {
            return (ServerBootstrap)((ServerBootstrap)super.configure(acceptor, eventloop).channel(EpollServerSocketChannel.class)).option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        }
    }

    private static class JDKTransport
    extends NettyTransport {
        private JDKTransport() {
        }

        @Override
        public EventLoopGroup createEventLoop(int threads, String threadName, int ioRatio) {
            NioEventLoopGroup loopGroup = new NioEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory(threadName));
            loopGroup.setIoRatio(ioRatio);
            return loopGroup;
        }

        @Override
        public ServerBootstrap configure(EventLoopGroup acceptor, EventLoopGroup eventloop) {
            return (ServerBootstrap)super.configure(acceptor, eventloop).channel(NioServerSocketChannel.class);
        }
    }
}

