/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Context;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.WebSocketCloseStatus;
import io.jooby.internal.netty.HttpRawPostRequestDecoder;
import io.jooby.internal.netty.NettyContext;
import io.jooby.internal.netty.NettyWebSocket;
import io.jooby.internal.netty.SlowPathChecks;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class NettyHandler
extends ChannelInboundHandlerAdapter {
    private static final AtomicReference<String> cachedDateString = new AtomicReference();
    private static final Runnable INVALIDATE_TASK = () -> cachedDateString.set(null);
    private static final AsciiString server = AsciiString.cached((String)"N");
    private static final AttributeKey<NettyContext> CONTEXT = AttributeKey.newInstance((String)"context");
    private final ScheduledExecutorService scheduler;
    private static final int DATE_INTERVAL = 1000;
    private final Router router;
    private final int bufferSize;
    private final boolean defaultHeaders;
    private final HttpDataFactory factory;
    private final long maxRequestSize;
    private long contentLength;
    private long chunkSize;
    private boolean http2;
    private NettyContext context;

    public NettyHandler(ScheduledExecutorService scheduler, Router router, long maxRequestSize, int bufferSize, HttpDataFactory factory, boolean defaultHeaders, boolean http2) {
        this.scheduler = scheduler;
        this.router = router;
        this.maxRequestSize = maxRequestSize;
        this.factory = factory;
        this.bufferSize = bufferSize;
        this.defaultHeaders = defaultHeaders;
        this.http2 = http2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (SlowPathChecks.isHttpRequest(msg)) {
            HttpRequest req = (HttpRequest)msg;
            this.context = new NettyContext(ctx, req, this.router, NettyHandler.pathOnly(req.uri()), this.bufferSize, this.http2);
            if (this.defaultHeaders) {
                this.context.setHeaders.set((CharSequence)HttpHeaderNames.DATE, (Object)NettyHandler.date(this.router.getLog(), this.scheduler));
                this.context.setHeaders.set((CharSequence)HttpHeaderNames.SERVER, (Object)server);
            }
            this.context.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            if (this.context.isHttpGet()) {
                this.router.match((Context)this.context).execute((Context)this.context);
                return;
            } else {
                this.contentLength = NettyHandler.contentLength(req);
                if (this.contentLength > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)req)) {
                    this.context.decoder = NettyHandler.newDecoder(req, this.factory);
                    return;
                } else {
                    this.router.match((Context)this.context).execute((Context)this.context);
                }
            }
            return;
        } else if (SlowPathChecks.isHttpContent(msg)) {
            HttpContent chunk = (HttpContent)msg;
            try {
                if (this.context.decoder == null) return;
                this.chunkSize += (long)chunk.content().readableBytes();
                if (this.chunkSize > this.maxRequestSize) {
                    this.resetDecoderState(this.context, true);
                    this.router.match((Context)this.context).execute((Context)this.context, Route.REQUEST_ENTITY_TOO_LARGE);
                    return;
                }
                this.offer(this.context, chunk);
                if (!SlowPathChecks.isLastHttpContent(msg)) return;
                Router.Match route = this.router.match((Context)this.context);
                this.resetDecoderState(this.context, !route.matches());
                route.execute((Context)this.context);
                return;
            }
            finally {
                this.release(chunk);
            }
        } else {
            if (!(msg instanceof WebSocketFrame) || this.context.webSocket == null) return;
            this.context.webSocket.handleFrame((WebSocketFrame)msg);
        }
    }

    private void release(HttpContent ref) {
        if (ref.refCnt() > 0) {
            ref.release();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.context != null) {
            this.context.flush();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        NettyWebSocket ws;
        if (evt instanceof IdleStateEvent && (ws = (NettyWebSocket)ctx.channel().attr(NettyWebSocket.WS).getAndSet(null)) != null) {
            ws.close(WebSocketCloseStatus.GOING_AWAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            Logger log = this.router.getLog();
            if (Server.connectionLost((Throwable)cause)) {
                if (log.isDebugEnabled()) {
                    if (this.context == null) {
                        log.debug("execution resulted in connection lost", cause);
                    } else {
                        log.debug("{} {}", new Object[]{this.context.getMethod(), this.context.getRequestPath(), cause});
                    }
                }
            } else if (this.context == null) {
                log.error("execution resulted in exception", cause);
            } else if (this.router.isStopped()) {
                log.debug("execution resulted in exception while application was shutting down", cause);
            } else {
                this.context.sendError(cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private void offer(NettyContext context, HttpContent chunk) {
        try {
            context.decoder.offer(chunk);
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException x) {
            this.resetDecoderState(context, true);
            context.sendError(x, StatusCode.BAD_REQUEST);
        }
    }

    private void resetDecoderState(NettyContext context, boolean destroy) {
        this.chunkSize = 0L;
        this.contentLength = -1L;
        if (destroy && context.decoder != null) {
            InterfaceHttpPostRequestDecoder decoder = context.decoder;
            context.decoder = null;
            decoder.destroy();
        }
    }

    private static InterfaceHttpPostRequestDecoder newDecoder(HttpRequest request, HttpDataFactory factory) {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            if (lowerContentType.startsWith("multipart/form-data")) {
                return new HttpPostMultipartRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
            if (lowerContentType.startsWith("application/x-www-form-urlencoded")) {
                return new HttpPostStandardRequestDecoder(factory, request, StandardCharsets.UTF_8);
            }
        }
        return new HttpRawPostRequestDecoder(factory, request);
    }

    static String pathOnly(String uri) {
        int len = uri.indexOf(63);
        return len > 0 ? uri.substring(0, len) : uri;
    }

    private static long contentLength(HttpRequest req) {
        String value = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException x) {
            return -1L;
        }
    }

    private static String date(Logger log, ScheduledExecutorService scheduler) {
        String dateString = cachedDateString.get();
        if (dateString == null) {
            long realTime = System.currentTimeMillis();
            long mod = realTime % 1000L;
            long toGo = 1000L - mod;
            dateString = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
            if (cachedDateString.compareAndSet(null, dateString)) {
                try {
                    scheduler.schedule(INVALIDATE_TASK, toGo, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejected) {
                    if (scheduler.isShutdown()) {
                        log.trace("server is shutting down", (Throwable)rejected);
                    }
                    throw SneakyThrows.propagate((Throwable)rejected);
                }
            }
        }
        return dateString;
    }
}

