/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.httpbridge;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.jeeintegration.httpbridge.HttpBridgeRegistryClient;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBridgeEndpointRegistryClient
implements HttpBridgeRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpBridgeEndpointRegistryClient.class);
    private final HttpClient httpClient;
    private final String endpointRegistryUri;
    private final ScheduledExecutorService scheduledExecutorService;

    @Inject
    public HttpBridgeEndpointRegistryClient(HttpClient httpClient, EndpointRegistryUriHolder endpointRegistryUriHolder, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduledExecutorService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Initialising HTTP Bridge Endpoint Registry Client with: %s and %s.", httpClient, endpointRegistryUriHolder.get()));
        }
        this.httpClient = httpClient;
        this.endpointRegistryUri = endpointRegistryUriHolder.get();
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public CompletionStage<Void> register(String endpointUrl, String channelId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Registering endpoint %s with registry %s for channel ID %s", endpointUrl, this.endpointRegistryUri, channelId));
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.scheduleWithRetries(result, 0L, 10, endpointUrl, channelId);
        return result;
    }

    private void scheduleWithRetries(CompletableFuture<Void> result, long delay, int remainingRetries, String endpointUrl, String channelId) {
        if (remainingRetries <= 0) {
            result.completeExceptionally((Throwable)new JoynrRuntimeException("Unable to register channel. Too many unsuccessful retries."));
        } else {
            LOG.debug("Scheduling execution of HTTP post for registering endpoint {} for channel {}.", (Object)endpointUrl, (Object)channelId);
            this.scheduledExecutorService.schedule(() -> {
                String topic = channelId;
                HttpPost message = new HttpPost(this.endpointRegistryUri);
                message.addHeader("Content-Type", "application/json");
                try {
                    StringEntity entity = new StringEntity(String.format("{\"endpointUrl\": \"%s\", \"topic\": \"%s\"}", endpointUrl, topic));
                    message.setEntity((HttpEntity)entity);
                    boolean executionResult = this.executeRequest(message);
                    if (executionResult) {
                        result.complete(null);
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.error(String.format("Unable to register endpoint %s / channel ID %s with broker at %s.", endpointUrl, channelId, this.endpointRegistryUri), (Throwable)e);
                }
                this.scheduleWithRetries(result, 10L, remainingRetries - 1, endpointUrl, channelId);
            }, delay, TimeUnit.SECONDS);
        }
    }

    private boolean executeRequest(HttpPost message) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to send message: " + message);
        }
        HttpResponse response = this.httpClient.execute((HttpUriRequest)message);
        boolean result = false;
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode >= 200 && responseCode < 300) {
            result = true;
        } else {
            String errorMessage = String.format("Response from registration endpoint was not successful.%n%s", response);
            LOG.error(errorMessage);
        }
        return result;
    }

    public static class EndpointRegistryUriHolder {
        @Inject(optional=true)
        @Named(value="joynr.jeeintegration.endpointregistry.uri")
        private String endpointRegistryUri;

        public EndpointRegistryUriHolder() {
        }

        public EndpointRegistryUriHolder(String endpointRegistryUri) {
            this.endpointRegistryUri = endpointRegistryUri;
        }

        public String get() {
            return this.endpointRegistryUri;
        }
    }
}

