/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.google.common.collect.Sets;
import io.joynr.UsedBy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.jeeintegration.JoynrIntegrationBean;
import io.joynr.jeeintegration.api.ServiceLocator;
import io.joynr.messaging.MessagingQos;
import io.joynr.util.AnnotationUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JeeJoynrServiceLocator
implements ServiceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JeeJoynrServiceLocator.class);
    private final JoynrIntegrationBean joynrIntegrationBean;

    @Inject
    public JeeJoynrServiceLocator(JoynrIntegrationBean joynrIntegrationBean) {
        this.joynrIntegrationBean = joynrIntegrationBean;
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain) {
        return this.get(serviceInterface, domain, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain, long ttl) {
        return this.get(serviceInterface, domain, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, Set<String> domains) {
        return this.get(serviceInterface, domains, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, Set<String> domains, long ttl) {
        return this.get(serviceInterface, domains, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        return this.get(serviceInterface, Sets.newHashSet((Object[])new String[]{domain}), messagingQos, discoveryQos);
    }

    @Override
    public <I> I get(final Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        if (this.joynrIntegrationBean.getRuntime() == null) {
            throw new IllegalStateException("You can't get service proxies until the joynr runtime has been initialised.");
        }
        final Class<?> joynrProxyInterface = this.findJoynrProxyInterface(serviceInterface);
        final Object joynrProxy = this.joynrIntegrationBean.getRuntime().getProxyBuilder(domains, joynrProxyInterface).setMessagingQos(messagingQos).setDiscoveryQos(discoveryQos).build();
        return (I)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Forwarding call to %s from service interface %s to joynr proxy %s", method, serviceInterface, joynrProxyInterface));
                }
                return joynrProxy.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(joynrProxy, args);
            }
        });
    }

    private <I> Class<?> findJoynrProxyInterface(Class<I> serviceInterface) {
        UsedBy usedByAnnotation = (UsedBy)AnnotationUtil.getAnnotation(serviceInterface, UsedBy.class);
        if (usedByAnnotation == null) {
            throw new IllegalArgumentException(String.format("Unable to find suitable joynr proxy for interface %s", serviceInterface));
        }
        return usedByAnnotation.value();
    }
}

