/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.routing.MessageRouter;
import joynr.system.RoutingTypes.MqttAddress;

public class SharedSubscriptionsMqttMessagingSkeleton
extends MqttMessagingSkeleton {
    private static final String NON_ALPHA_REGEX_PATTERN = "[^a-zA-Z]";
    private String channelId;
    private String receiverId;

    @Inject
    public SharedSubscriptionsMqttMessagingSkeleton(@Named(value="property_mqtt_address") MqttAddress ownAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, MqttMessageSerializerFactory messageSerializerFactory, @Named(value="joynr.messaging.channelid") String channelId, @Named(value="joynr.messaging.receiverid") String receiverId) {
        super(ownAddress, messageRouter, mqttClientFactory, messageSerializerFactory);
        this.channelId = channelId;
        this.receiverId = receiverId;
    }

    protected void subscribe() {
        this.getClient().subscribe("$share:" + this.sanitiseChannelIdForUseAsTopic() + ":" + this.getOwnAddress().getTopic() + "/#");
        this.getClient().subscribe("replyto/" + this.getOwnAddress().getTopic() + "/" + this.receiverId + "/#");
    }

    private String sanitiseChannelIdForUseAsTopic() {
        String result = this.channelId.replaceAll(NON_ALPHA_REGEX_PATTERN, "");
        if (result.isEmpty()) {
            throw new IllegalArgumentException(String.format("The channel ID %s cannot be converted to a valid MQTT topic fragment because it does not contain any alpha characters.", this.channelId));
        }
        return result;
    }
}

